/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifndef PB_SDK
	#include <dos.h>
	#include <string.h>
	#ifdef _MSC_VER
	#include <sys/types.h>
	#endif
	#include <sys/stat.h>
#endif

static int _unlink_file(const char *path, _dos_ffblk *file);

/*
** findfirst-findnext combo, executes func for each file found
*/
	int
rmfile( const char *path )
{
	char       pathspec[MAXPATH];
	_dos_ffblk file;
	int        done;

	strcpy( pathspec, basedir(path) );
	done = ff_findfirst( (char *)path, FA_ALL, &file );
	while( !done ){
		if( -1 == _unlink_file(pathspec, &file) ) return -1;
		done = ff_findnext( &file );
	}
	return 0;
}

/*
** Removes a single file, used internally by rmfile()
*/
	int
_unlink_file( const char *path, _dos_ffblk *file )
{
	char buf[81];

	if( '.' == file->name[0] || file->attrib & FA_DIREC ) return 0;

	strcat( strcpy( buf, path ), file->name );
	chmod( buf, S_IREAD | S_IWRITE );
	return unlink( buf );
}

