/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifndef PB_SDK
	#include <dos.h>
	#include <string.h>
	#ifdef _MSC_VER
		#include <sys/types.h>
	#endif
	#include <sys/stat.h>
#endif

static int __doRemove( const char *path );

#ifdef PB_SDK
/*
** rmdir: same as standard C library rmdir(), only in SDK mode
*/
   int
rmdir( const char *path )
{
	struct SREGS s;
	union  REGS  r;

	s.ds = FP_SEG(path);
	r.x.dx = FP_OFF(path);
	r.h.ah = 0x3a;
	int86x( 0x21, &r, &r, &s );
	if( r.x.cflag ) return -1;
	else return 0;
}
#endif /* PBSDK mode only */

/*
 * this is the wrapper function, strips the trailing backslash (if any)
*/
	int
rmDirTree( char *path )
{
	char *p;

	/* remove any trailing backslashes, those will be appended later */
	if( '\\' == *(p = &path[strlen(path) - 1]) ) *p = EOS;
	return __doRemove( path );
}


/*
 * a simple rescursive directory tree parser, deletes all files on its way
*/
	int
__doRemove( const char *curPath )
{
	_dos_ffblk ffblk;
	char       path[MAXPATH], newPath[MAXPATH];
	int        done;

	strcat( strcpy(path, curPath), "\\*.*" );

	done = ff_findfirst(path, FA_ALL, &ffblk);
	while( !done ){
		if( ffblk.attrib & FA_DIREC ){
			if( '.' != *ffblk.name ){
				strcat( strcpy(newPath, curPath), "\\" );
				__doRemove( strcat(newPath, ffblk.name) );
				if( -1 == rmdir(newPath) ) return -1;
			}
		}
		else{
			strcat( strcpy(newPath, curPath), "\\" );
			chmod( strcat(newPath, ffblk.name), S_IREAD | S_IWRITE );
			if( -1 == unlink(newPath) ) return -1;
		}
		done = ff_findnext(&ffblk);
	}

	/* can't remove current directory */
	if( 0 != strcmp(curPath, ".") )	return rmdir((char *)curPath);
	else return 0;
}

