/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifdef PB_SDK

/*
** mkdir: same as standard C library mkdir(), only in SDK mode
*/
   int
mkdir( const char *path )
{
	struct SREGS s;
	union  REGS  r;

	s.ds = FP_SEG(path);
	r.x.dx = FP_OFF(path);
    r.h.ah = 0x39;
	int86x( 0x21, &r, &r, &s );
	if( r.x.cflag ) return -1;
	else return 0;
}

#endif /* SDK mode */

/*
** Creates a whole path
*/
	int
mkDirTree( char *path )
{
	char *p;

	if( '\\' == path[2]  || '/' == path[2]  ) p = &path[3];
	else p = path;

	for( ; *p; ++p ){
		if( '\\' == *p || '/' == *p ){
			char ch = *p;
			*p = EOS;
			mkdir( path );
			*p = ch;
		}
	}
	return mkdir( path );
}
