/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifdef PB_SDK

/*
 * gets the current working directory in form 'D:\PATH'. The drive letter
 * and colon are always present and there's no terminating backslash. If
 * 'buflen' is less than the resulting path or if another error occurs,
 * NULL is returned. Otherwise, the result is copied into 'path' and 'path'
 * is returned (NUL-terminated string).
*/
	char*
getcwd( char *path, int buflen )
{
	char   buf[127];
	union  REGS  regs;
	struct SREGS sregs;

	/* get the current directory in a local buffer */
	regs.h.ah = 0x47;
	regs.h.dl = 0;
	regs.x.si = FP_OFF(buf);
	sregs.ds  = FP_SEG(buf);
	int86x( 0x21, &regs, &regs, &sregs );
	if( 0 != regs.x.cflag ) return NULL;

	/* make sure we have enough space to store the result */
	if( strlen(buf) + 3 >= buflen ) return NULL;

	/* get the current default drive */
	regs.h.ah = 0x19;
	int86( 0x21, &regs, &regs );

	/* add the leading drive letter, colon and backslash and return path */
	*path = regs.h.al + 'A'; strcpy( path + 1, ":\\" );
	return strcat( path, buf );
}

#endif
