/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

/*
** Copies one file to another, overwriting dest if it exists
*/
	int
cpfile( const char *dest, const char *src )
{
	FILE *sfp, *dfp;
	char buf[0x400];

	if( NULL == (sfp = fopen(src, "rb")) )  return -1;
	if( NULL == (dfp = fopen(dest, "wb")) ){
		fclose(sfp);
		return -1;
	}

	if( setvbuf( sfp, NULL, _IOFBF, 0x4000 ) ){
		fclose(sfp);
		fclose(dfp);
		return -1;
	}

	for( ;; ){
		int st = fread( buf, sizeof(char), 0x400, sfp );
		if( 0 == st ) break;
		fwrite( buf, sizeof(char), st, dfp );
	}

	fclose( sfp );
	fclose( dfp );
	return 0;
}
