/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifdef PB_SDK

static int __ichmod( const char *path, int func, int attrib );

/*
 * chmod() version for the SDK
*/
	int
chmod( const char *path, int amode )
{
	int attr;

	attr = __ichmod(path, 0, 0);
	if( -1 == attr ) return -1;
	if( amode & S_IWRITE ) attr &= ~0x0001;
	return (-1 != __ichmod(path, 1, attr)) ? 0 : -1;
}

	int
__ichmod(const char *path, int func, int attrib )
{
	struct SREGS s;
	union  REGS  r;

	r.h.ah = 0x43;
	r.h.al = func;
	r.x.cx = attrib;
	s.ds = FP_SEG(path);
	r.x.dx = FP_OFF(path);
	int86x(0x21, &r, &r, &s);
	if( r.x.cflag ) return -1;
	else return r.x.cx;
}
#endif
