/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifndef PB_SDK
#include <string.h>
#endif

/*
 * Changes the file extension of src to ext, returns dest
 * If ext is NULL, remove the existing extension, ext must have the period!
*/
	char*
chext( char *dest, const char *src, const char *ext )
{
	char *p = strrchr( strcpy( dest, src ), '.' );

	/* no period, simply append extension if needed */
	if( !p ){
		if( ext ) strcat( dest, ext );
		return dest;
	}

	/* see if we have a period in a subdirectory specification */
	if( strlen(p) > 4 || strchr(p, '\\') || strchr(p, '/') ){
		if( ext ) strcat( dest, ext );
		return dest;
	}

	/* see if we need to add, change or remove the extension */
	if( ext ) strcpy( p, ext );
	else *p = EOS;

	return dest;
}

