/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifdef PB_SDK
/*
 * same as standard C library chdir(), we only compile this in SDK mode
*/
	int
chdir( const char *path )
{
	struct SREGS s;
	union  REGS  r;

	s.ds = FP_SEG( path );
	r.x.dx = FP_OFF( path );
	r.h.ah = 0x3b;
	int86x( 0x21, &r, &r, &s );
	if( r.x.cflag ) return -1;
	else return 0;
}
#else
/* nothing, for some reason MSC does not like empty files ifndef PB_SDK */
#endif
