/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __TURBOC__
#ifndef __CONIO_H
#include <sys/__conio.h>
#endif

#ifndef PB_SDK
#include <dos.h>
#include <stdarg.h>
#include <stdio.h>
#include <assert.h>

#undef putch

static struct{
	char x1, y1, x2, y2;
	char attr;
	char mode, page;
} __con;

#define SCROLL_UP    0x06
#define CPRINTF_BUF  2000

#define MAP_X(x)        ( (x) & 0xff       )
#define MAP_Y(y)        ( (y) >> 8         )
#define CHECK_COORD(x1,y1,x2,y2) do{\
		assert( x1 > 0 && x1 <= 80 && x2 > 0 && x2 <= 80 && x1 < x2 );\
		assert( y1 > 0 && y1 <= 25 && y2 > 0 && y2 <= 25 && y1 < y2 );\
	}while(0)

/*
 * global that's == 1 if __coninit() has been called already
*/
static int __conready = 0;
	   int _wscroll  = 1;

/*
 * helper functions (local to this module)
*/
static void __coninit(void);
static void __scroll(int, int, int, int, int, int, int);
static int  __getxy(void);
static void __movexy(int x, int y );

/*
 
  Local helper functions
 
*/
	void
__coninit( void )
{
	union REGS regs;

	regs.h.ah = 0x0f;
	int86( 0x10, &regs, &regs );
	__con.mode = regs.h.al;
	__con.page = regs.h.bh;

	/* set new mode if necessary */
	if( 2 != __con.mode && 3 != __con.mode && 7 != __con.mode ){
		regs.x.ax = 0x0003;
		int86( 0x10, &regs, &regs );
	}

	__con.x1 = __con.y1 = 0;
	__con.x2 = 79; __con.y2 = 24;
	__con.attr = MK_ATTRIB( BLACK, LIGHTGRAY );

	__conready = 1;
}

	int
__getxy( void )
{
	union REGS regs;

	regs.h.ah = 0x03;
	regs.h.bh = __con.page;
	int86( 0x10, &regs, &regs );
	return regs.x.dx;  /* row/col */
}

	void
__scroll( int x1, int y1, int x2, int y2, int attr, int nlines, int direc )
{
	union REGS regs;

	regs.h.ah = direc; regs.h.bh = attr; regs.h.al = nlines;
	regs.h.ch = y1; regs.h.cl = x1;
	regs.h.dh = y2; regs.h.dl = x2;
	int86( 0x10, &regs, &regs );
}

	void
__movexy( int x, int y )
{
	union REGS regs;

	regs.h.ah = 0x02;
	regs.h.bh = __con.page;
	regs.h.dh = y;
	regs.h.dl = x;
	int86( 0x10, &regs, &regs );
}

/*
 
  Public functions for the console module
 
*/
	void
clrscr( void )
{
	if( !__conready ) __coninit();
	__scroll( __con.x1, __con.y1, __con.x2, __con.y2, __con.attr,
			  0, SCROLL_UP );
	gotoxy(1, 1);
}

	void
clreol( void )
{
	int i = __getxy();
	int x = MAP_X(i) + __con.x1;
	int y = MAP_Y(i) + __con.y1;

	if( !__conready ) __coninit();
	__scroll( x, y, __con.x2, y + 1, __con.attr, 1, SCROLL_UP );
}

	void
gotoxy( int x, int y )
{
	if( !__conready ) __coninit();
	__movexy( x + __con.x1 - 1, y + __con.y1 - 1);
}

	int
putch( int ch )
{
	union REGS regs;
	int x, y;

	/* adjust the cursor position */
	if( !__conready ) __coninit();
	x = MAP_X(__getxy()); y = MAP_Y(__getxy());

	switch( ch ){
		case '\b': if( x > __con.x1 ) x--; break; /* backspace */
		case '\r': x = __con.x1; break; /* carriage return */
		case '\n': ++y; break; /* new line */
		/* bell, write as TTY (treats it as ctrl char) */
		case '\a': regs.x.ax = 0x0e07; int86( 0x10, &regs, &regs ); break;

		default: /* regular character */
			__movexy( x, y );
			regs.h.ah = 0x09;
			regs.h.al = ch;
			regs.h.bh = __con.page;
			regs.h.bl = __con.attr;
			regs.x.cx = 1;
			int86( 0x10, &regs, &regs );

			x++;
	}

	if( x > __con.x2 ){
		x = __con.x1;
		y += _wscroll;
	}

	if( y > __con.y2 ){
		__scroll( __con.x1, __con.y1, __con.x2, __con.y2,
				  __con.attr, 1, SCROLL_UP );
		y--;
	}

	__movexy( x, y );
	return ch;
}

	int
getch( void )
{
	union REGS regs;

	if( !__conready ) __coninit();
	regs.h.ah = 0x01;
	int86( 0x21, &regs, &regs );
	return regs.h.al;
}

	int
getche( void )
{
	int ch = getch();

	if( !__conready ) __coninit();
	putch( ch );
	return ch;
}

	int
wherex( void )
{
	if( !__conready ) __coninit();
	return MAP_X(__getxy()) - __con.x1 + 1;
}

	int
wherey( void )
{
	if( !__conready ) __coninit();
	return MAP_Y(__getxy()) - __con.y1 + 1;
}

	int
cprintf( const char *format, ... )
{
	static char buf[CPRINTF_BUF], *p;
		   int  i;
	   va_list  argp;

	if( !__conready ) __coninit();
	va_start(argp, format);
	vsprintf( buf, format, argp );
	va_end(argp);

	for( i = 0, p = buf; '\0' != *p; ++p, ++i ) putch( *p );
	return i ? i - 1 : 0;
}

	int
cputs( const char *s )
{
	if( !__conready ) __coninit();
	while( *s ) putch( *s++ );
	return *(s - 1);
}

	void
textattr( int attr )
{
	if( !__conready ) __coninit();
	__con.attr = attr;
}

	void
textcolor( int color )
{
	if( !__conready ) __coninit();
	__con.attr = (__con.attr & ~0x0f) | (color & 0x0f);
}

	void
textbackground( int color )
{
	if( !__conready ) __coninit();
	__con.attr = (__con.attr & ~0xf0) | ((color & 0x0f) << 4);
}

	void
window( int x1, int y1, int x2, int y2 )
{
	if( !__conready ) __coninit();
	CHECK_COORD(x1, y1, x2, y2);
	__con.x1 = x1; __con.y1 = y1;
	__con.x2 = x2; __con.y2 = y2;
}

	int
gettext( int x1, int y1, int x2, int y2, void *dest )
{
	union REGS  regs;
		   int  i, j;
		  char *p = (char *)dest;

	if( !__conready ) __coninit();
	CHECK_COORD(x1, y1, x2, y2 );
	for( i = y1 - 1; i < y2; ++i ){
		for( j = x1 - 1; j < x2; ++j ){
			__movexy(j, i);
			regs.h.ah = 0x08;
			regs.h.bh = __con.page;
			int86( 0x10, &regs, &regs );
			*p++ = regs.h.al;
			*p++ = regs.h.ah;
		}
	}
	return 1;
}

	int
puttext( int x1, int y1, int x2, int y2, void *src )
{
	union REGS  regs;
		   int  i, j;
		  char *p = (char *)src;

	if( !__conready ) __coninit();
	CHECK_COORD(x1, y1, x2, y2 );
	for( i = y1 - 1; i < y2; ++i ){
		for( j = x1 - 1; j < x2; ++j ){
			__movexy(j, i);
			regs.h.ah = 0x09;
			regs.h.bh = __con.page;
			regs.h.al = *p++;
			regs.h.bl = *p++;
			regs.x.cx = 1;
			int86( 0x10, &regs, &regs );
		}
	}
	return 1;
}

#undef CHECK_COORD
#undef MAP_X
#undef MAP_Y
#undef SCROLL_UP
#undef CPRINTF_BUF

#endif /* __CONIO.C */
#endif /* ifndef TURBOC */
