@echo off
goto Begin

PB-Lib C/C++ Library Version 0.021

Copyright (C) 1995 by Branislav L. Slantchev
A product of Silicon Creations, Inc.

See the file "copying.pbl" for licensing information.

Build a version of the library.

The library will be put in %SILICON%\LIB and the name depends on the
compiler used to create it. The suffix signifies the library mode.

rem 
rem  See if we have the required compiler keyword
rem 
:Begin
echo build v1.0r1 Copyright (C) 1995 by Branislav L. Slantchev
if not %1$ == $ goto ckp1
:_help
	echo 
	echo Syntax: %0 keyword [-p]
	echo 
	echo    'keyword' is required and can be one of the following
	echo        all      - build all compiler versions
	echo        bc3      - Borland C++ 3.1
	echo        ztc3     - Zortech C++ 3.0
	echo        msc6     - Microsoft C 6.0
	echo        sc6      - Symantec C++ 6.0
	echo        wc10     - Watcom C++ 10.0
	echo 
goto __skip
	echo        gcc2     - DJGPP 2.60
:__skip
	echo    '-p' is optional and will create PBSDK online library
	echo 
goto End

rem 
rem  See if we recognize the compiler keyword
rem 
:ckp1
for %%v in (all bc3 ztc3 msc6 sc6 gcc2 wc10 ) do if %1$ == %%v$ goto %1
	echo 
	echo %0: (fatal) '%1' is not recognized.
goto _help

rem 
rem  Setup the compiler environment
rem 
:all
	call %0 bc3 %2
	call %0 ztc3 %2
	call %0 msc6 %2
goto End

:bc3
	call %SILICON%\etc\startup\borland.bat
goto ckp2
:ztc3
	call %SILICON%\etc\startup\zortech.bat
goto ckp2
:msc6
	call %SILICON%\etc\startup\microsft.bat
goto ckp2
:sc6
	call %SILICON%\etc\startup\symantec.bat
goto ckp2
:wc10
	call %SILICON%\etc\startup\watcom.bat
goto ckp2
:gcc2
	echo 
	echo not implemented yet: '%1'
goto End

rem 
rem  Check second parameter for the '-p' option
rem 
:ckp2
set PB_SDK=
if %2$ == -p$ set PB_SDK=1

cd %SILICON%\PBLIB

rem 
rem  Remove all object files and copy the library template file
rem 
if exist %SILICON%\tmp\*.* %SILICON%\bin\rm -f %SILICON%\tmp\*

rem 
rem  Generate the .OBJ files
rem 
cls
echo Creating the fixes...
cd fixes
dmake PB_SDK=%PB_SDK%
cls
echo Creating file and directory access modules...
cd ..\fsys
dmake PB_SDK=%PB_SDK%
cls
echo Creating miscellaneous C tools modules...
cd ..\libc
dmake PB_SDK=%PB_SDK%
cls
echo Creating the ProBoard-specific modules...
cd ..\proutil
dmake PB_SDK=%PB_SDK%
cls
echo Creating the string library...
cd ..\string
dmake PB_SDK=%PB_SDK%
cls
echo Creating the system utilities library...
cd ..\sysutil
dmake PB_SDK=%PB_SDK%

rem 
rem  Now build the .LIB library file
rem 
cls
echo Now building the library...
cd %SILICON%\tmp
dmake -f %SILICON%\ETC\PBLIB-AR.DEF PB_SDK=%PB_SDK%
cd %SILICON%\pblib
echo 
echo %0: Done! 

:End
