/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __STDARG_H
#define __STDARG_H

#ifndef PB_SDK
#error If you're not using PEX mode, then #include <stdarg.h>, not this!
#endif

/*
 ***************************************************************************
	 Fix the buggy PB_SDK: it does not handle variable arguments properly
 ***************************************************************************
*/

#ifndef __MACDEF_H
#include <macdef.h>
#endif

/*
 * this is the va_list definition
*/
typedef void __FAR *va_list;

/*
 * this will make the size always even by adding 1 to the odd numbers
*/
#define __size(t) ( (sizeof(t)+1) & 0xFFFE )

/*
 * set the 'a' pointer to the memory location right after fix (param)
*/
#define va_start(a,fix) \
	( (void)((a) = (va_list)((char __FAR *)(&fix)+__size(fix))) )

/*
* retrieve address of next variable of type 't' and increment pointer
*/
#define va_arg(a,t) \
	( *(t __FAR *)(((*(char __FAR* __FAR*)&(a))+=__size(t))-(__size(t))) )

/*
 * a do-nothing NOP
*/
#define va_end(a)   ( (void)0 )

#endif
