/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __CONIO_H
#define __CONIO_H

#ifndef __COLORS
#define __COLORS
typedef enum {
	BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, LIGHTGRAY,
	DARKGRAY, LIGHTBLUE, LIGHTGREEN, LIGHTCYAN, LIGHTRED, LIGHTMAGENTA,
	YELLOW, WHITE, BLINK = 128
} COLORS;
#endif

#define MK_ATTRIB(b,f)  ( (f) | ((b) << 4) )

/* these are not available for the SDK */
#if !defined( PB_SDK ) && !defined( __TURBOC__ )
#ifdef __cplusplus
	extern "C" {
#endif

void gotoxy(int x, int y);
void clrscr(void);
int  getch(void);
int  getche(void);
int  putch(int ch);
void clreol(void);
int  wherex(void);
int  wherey(void);
int  cprintf(const char *format, ... );
int  cputs(const char *s);
void textattr(int attr);
void textcolor(int color);
void textbackground(int color);
void window(int x1, int y1, int x2, int y2);
int  gettext(int x1, int y1, int x2, int y2, void *dest);
int  puttext(int x1, int y1, int x2, int y2, void *src);

#ifdef __cplusplus
	}
#endif
/* SDK or Borland */
#else
#ifdef PB_SDK /* not all are available */
	#define textattr  SetFullColor
	#define gotoxy    GotoXY
	#define clreol    ClrEol
	#define clrscr()  do{CurUser->uFlags |= UFLAG_CLEAR; puts("\f");}while(0)
	#define getch     PeekChar
	#define getche    getchar
	#define cprintf   printf
	#define cputs     puts
#else
	#include <conio.h>
#endif /* SDK only */
#endif /* SDK/Borland/Others */
#endif
