/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __RADEFS_H
#define __RADEFS_H

/*																		   *\
 ***************************************************************************
				 RA-compatible structures for USERS.BBS, et al.
 ***************************************************************************
\*                                                                         */

#include <typedef.h>

typedef char raTime[6];   /* RA-style time format, HH:MM, Pascal string    */
typedef char raDate[9];   /* RA-style date format, MM-DD-YY, Pascal string */
typedef char rsStr;       /* RA-style Pascal string, see note below        */

/*
	NOTES
		1.  Strings are Pascal-style, i.e. first byte == length,
			and there's no NUL-terminator;
		2.  Flags for attribute? are defined in this file too.
*/

/*
 
  USERS.BBS
 
 The RAFx_xxxx flags are for the attribute variables in the USER structure.
 The RAF1_xxxx are for attribute1 and RAF2_xxxx - for attribute2. "n/a"
 means that this flag is not applicable for ProBoard.
*/
#define RAF1_DELETED       0x01    /* User is deleted                    */
#define RAF1_CLEAR         0x02    /* Clear screen                       */
#define RAF1_PAUSE         0x04    /* More prompt                        */
#define RAF1_ANSI          0x08    /* ANSI                               */
#define RAF1_NOKILL        0x10    /* No kill                            */
#define RAF1_IGNORE        0x20    /* Transfer priority                  */
#define RAF1_FSED          0x40    /* Full-screen editor                 */
#define RAF1_QUIET         0x80    /* Quiet mode                         */
#define RAF2_HOTKEYS       0x01    /* Hot-keys                           */
#define RAF2_AVATAR        0x02    /* AVATAR/0                           */
#define RAF2_FSVIEW        0x04    /* Full-screen message viewer (n/a)   */
#define RAF2_HIDDEN        0x08    /* Hide activity                      */
#define RAF2_PAGEPRI       0x10    /* Page priority                      */
#define RAF2_NOECHOMAIL    0x20    /* No echo mail when checked  (n/a)   */
#define RAF2_GUEST         0x40    /* Guest account                      */
#define RAF2_POSTBILL      0x80    /* Post bill                  (n/a)   */

typedef struct{
	rsStr  name[36];          /* User's name                            */
	rsStr  city[26];          /* User's home city                       */
	rsStr  company[51];       /* User's company                         */
	rsStr  address1[51];      /* Address, first line                    */
	rsStr  address2[51];      /* Address, second line                   */
	rsStr  address3[51];      /* Address, third line                    */
	rsStr  alias[36];         /* Alias/Handle                           */
	rsStr  comment[81];       /* Comment                                */
	dword  passWordCRC;         /* CRC of the password                    */
	rsStr  dataPhone[16];     /* Data phone                             */
	rsStr  voicePhone[16];    /* Voice phone                            */
	raTime lastTime;            /* Last login time (hh:mm)                */
	raDate lastDate;            /* Last login date (MM-DD-YY)             */
	byte   attribute1;          /* Flags: see RAF1_???                    */
	byte   attribute2;          /* Flags: see RAF2_???                    */
	byte   aFlags[4];           /* User flags (not a dword!)              */
	dword  credit;              /* Netmail credit                         */
	dword  pending;             /* Pending credit                         */
	word   msgsPosted;          /* Number of posted messages              */
	word   level;               /* User's security level                  */
	dword  highMsgRead;         /* Last message read                      */
	dword  timesCalled;         /* Total number of calls                  */
	dword  numUploads;          /* Total number of uploads                */
	dword  numDownloads;        /* Total number of downloads              */
	dword  kbUploaded;          /* Total KBytes uploaded                  */
	dword  kbDownloaded;        /* Total KBytes downloaded                */
	dword  kbToday;             /* KBytes downloaded today                */
	word   timeUsed;            /* Time used today (minutes)              */
	int    screenLength;        /* User's screen length (# of lines)      */
	byte   lastPwdChange;       /* ??? Last password change               */
	word   group;               /* ???                                    */
	int    combinedBoards[200]; /* ??? Combined boards                    */
	raDate firstDate;           /* Date of first login (MM-DD-YY)         */
	raDate birthDate;           /* User's birthdate (MM-DD-YY)            */
	raDate subDate;             /* ??? additional date                    */
	byte   screenWidth;         /* User's screen width (# of columns)     */
	byte   language;            /* ??? Language                           */
	byte   dateFormat;          /* Date format                            */
	rsStr  forwardTo[36];     /* Forward messages to                    */
	word   msgArea;             /* Last message area used                 */
	word   fileArea;            /* Last file area used                    */
	byte   defaultProtocol;     /* Default transfer protocol              */
	int    fileGroup;           /* Last file group used                   */
	byte   lastDOBCheck;        /* ??? Last date of birth check           */
	byte   sex;                 /* Sex - 0: Unknown, 1: Male, 2: Female   */
	dword  USERSXIrec;          /* Number of record in USERSXI.BBS        */
	int    msgGroup;            /* Last message group used                */
	char   extra[48];
} USERS;

/*
 
  USERSIDX.BBS
 
 NOTE: the 32-bit CRC calculation is performed on the uppercased name and
	   alias. Also note that while the standard (and correct) way of
       returning the CRC is ~curCRC, don't do this. There's a bug in RA's
       implementation which ProBoard dutifully duplicates. Instead, return
       the non '~' value: this is the CRC stored in the user index.
*/
typedef struct{
	dword nameCRC32;            /* 32-bit CRC of user's name              */
	dword aliasCRC32;           /* 32-bit CRC of user's alias             */
} USERSIDX;

/*
 
   USERSXI.BBS
 
*/
typedef struct{
	char unused[200];           /* Currently unused space                 */
} USERSXI;

#endif
