/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __STRLIB_H
#define __STRLIB_H

/*
 ***************************************************************************
                       String manipulation library
 ***************************************************************************
*/

#ifndef __PBLIB_H
#include <pblib.h>
#endif

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
	#include <ctype.h>
	#include <time.h>
	#include <stdarg.h>
	#include <stdlib.h>
#endif

#define strequ(a,b)   ( 0 == strcmp(a,b)  )
#define strnequ(a,b)  ( 0 != strcmp(a,b)  )
#define striequ(a,b)  ( 0 == stricmp(a,b) )
#define strinequ(a,b) ( 0 != stricmp(a,b) )

#ifdef __cplusplus
	extern "C" {
#endif

char *strichr( const char *s, int ch );
char *stristr( const char *s1, const char *s2 );
char *strecpy( char *dest, const char *src );
char *strnecpy( char *dest, const char *src, size_t n );
char *strdel( char *s, size_t index, size_t n );
char *strins( char *s1, const char *s2, size_t index );
char *strtrm( char *s );
char *strrtrm( char *s );
char *strcma( char *dest, const char *src );
char *strtime( void );
char *strdate( void );
char *strcins( char *s, size_t index, int ch );
char *strcdel( char *s, size_t index );
char *strccat( char *s, int ch );
char *strtts( const char *s, int n );
char *strleft( char *dest, const char *src, size_t n );
char *stright( char *dest, const char *src, size_t n );
char *strmid( char *dest, const char *src, size_t index, size_t n );
char *strvcat( char *s, ... );
char *strcent( char *dest, const char *src, size_t n );
char *strneset( char *s, int ch, size_t n );
char *strfmpas( char *dest, const char *src );
char *strtopas( char *dest, const char *src );
char *strfupr( char *s, const char *sep );
char *strcrm( char *s, int c );
char *strcrep( char *s, int c1, int c2 );
char *strsrm( char *s1, const char *s2 );
char *strsrep( char *s1, const char *s2, const char *s3 );
char *stradd( char *dest, const char *s1, const char *s2 );

#ifdef __cplusplus
	}
#endif

#endif
