/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PBLIB_H
#define __PBLIB_H

/*
 ***************************************************************************
			This is the only file you need to include in PB PEX/EXEs
 ***************************************************************************
*/

#include <typedef.h>
#include <macdef.h>
#include <portable.h>
#include <sys\_pblver.h>
#include <sys\_pbnames.h>
#include <sys\_radefs.h>
#include <sys\_pbdefs.h>

/*
 * If we are compiling in PEX mode, pull in the SDK's Standard C Library
 * interface together with the PBLib expansions. Also, pull in the SDK
 * interface too.
*/
#ifdef PB_SDK
	#include <sys/_pbstdc.h>
	#include <sys/_pbsdk.h>
	#include <sys/__assert.h>
	#include <sys/__scanf.h>
	#include <sys/__conio.h>
#else
/*
 * If we are compiling in EXE mode, map the long math functions.
*/
	#define l_mul(v1,v2)   ( (long)(v1) * (v2)       )
	#define l_div(v1,v2)   ( (long)(v1) / (v2)       )
	#define l_mod(v1,v2)   ( (long)(v1) % (v2)       )
	#define l_shl(v,s)     ( (long)(v) << (uint)(s)  )
	#define l_shr(v,s)     ( (long)(v) >> (uint)(s)  )
	#define ul_div(v1,v2)  ( (dword)(v1) / (v2)      )
	#define ul_mod(v1,v2)  ( (dword)(v1) % (v2)      )
	#define ul_shl(v,s)    ( (dword)(v) << (uint)(s) )
	#define ul_shr(v,s)    ( (dword)(v) >> (uint)(s) )
#endif /* #ifdef PB_SDK */

/* some general useful stuff here */
#define MAXPATH   80
#define MAXDRIVE  3
#define MAXDIR    66
#define MAXFILE   9
#define MAXEXT    5

#endif

