/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __GREP_H
#define __GREP_H

/*
 ****************************************************************************
			  Regular expression matching and wildcard globbing
 ****************************************************************************
*/

#ifndef __PBLIB_H
#include <pblib.h>
#endif

#define MAXPAT 512        /* maximum compiled pattern length, should be Ok */

#define GREP_OK      0    /* no errors                                     */
#define GREP_BADESC  1    /* the escape character was followed by EOS      */
#define GREP_OVRFLOW 2    /* pattern too complex, internal buffer overflow */
#define GREP_BADSET  3    /* bad set specification, not terminated         */
#define GREP_BADPAT  4    /* bad pattern, '*' or '+' not allowed here      */
#define GREP_BADSTAR 5    /* '*' followed another '*', error in globbing   */

#ifdef __cplusplus
	extern "C" {
#endif

extern int grepError;     /* holds the error code if any grep failure      */

int   grep_compile( const char *pat );
char *grep_match( const char *line );
char *grep( const char *pat, const char *line );

int   glob_compile( const char *pat );
int   glob_match( const char *s );
int   glob( const char *pat, const char *s );

#ifdef __cplusplus
	}
#endif
#endif
