/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __CRC32_H
#define __CRC32_H

#ifndef __PBLIB_H
#include <pblib.h>
#endif

extern dword tblCRC32[];   /* pre-calculated table defined in CRC32.C */

/*
 * Updates the CRC32 value: c is the new int, crc is the current CRC32
*/
#define UpdateCRC32(c,crc) (tblCRC32[(byte)((c)^(crc)) & 0xff]^ul_shr(crc,8))

#ifdef __cplusplus
	extern "C" {
#endif

int   fileCRC32( const char *path, dword *CRC32 );
dword bufCRC32( const char *buf, size_t len );

#ifdef __cplusplus
	}
#endif
#endif
