
STRNESET		PB-Lib C/C++ Library Programmer's Manual		STRNESET


NAME
	strneset - sets characters of string to specified value

SYNOPSIS
	#include <strlib.h>

	char *strneset(char *s, int ch, size_t n);

DESCRIPTION
	Same as strnset() except it always NUL-terminates the destination
	string. strneset() sets the first n characters of string s to
	value ch. The buffer allocated for s must be large enough to accomodate
	at least n + 1 characters since no error checking is done. Actually,
	s is not treated as a string, but as a buffer whose first n bytes
	will be set to ch value. The difference is that the result will
	always be terminated by the NUL character. The function returns	s.

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char buf[50];

		printf( "%s\n", strneset(buf,'a',49) );
		return 0;
	}

