
STRNECPY			PB-Lib C/C++ Library Programmer's Manual		STRNECPY


NAME
	strnecpy - copies a specified number of bytes to a string

SYNOPSIS
	#include <strlib.h>

	char *strnecpy(char *dest, const char *src, size_t n);

DESCRIPTION
	Same as strncpy() except it always NUL-terminates the destination.
	This function copies n bytes from src into dest and returns dest.
	Destination buffer must be big enough to accomodate the resulting
	string. If n > strlen(s), the copying stops after the end of the
	source string.

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char *cbuf = "This is a long constant buffer.";
		char  ebuf[30];

		printf( "%s\n", strnecpy(ebuf,cbuf,10) );
		return 0;
	}

