
STRADD			PB-Lib C/C++ Library Programmer's Manual			STRADD


NAME
	stradd - adds two numbers represented as strings

SYNOPSIS
	#include <strlib.h>

	char *stradd(char *dest, const char s1, const char *s2);

DESCRIPTION
	stradd() adds the two numbers s1 and s2 and places the result in
	dest. The destination buffer must be large enough to hold the result.
	This function is fairly unsophisticated: it does not know anything
	about signs or separators. It only works on integers.

RETURN VALUES
	stradd() returns dest on success or NULL otherwise (and the contents
	of dest will be '\0').

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char buf[255], a[255], b[255];
		int i, len1, len2;

		do{
			printf( "\nPress [Enter] twice to quit.\n" );
			printf( "?a = " ); gets( a );
			printf( "?b = " ); gets( b );
			if( EOS == *a || EOS == *b ) return;
			stradd( buf, a, b );
			len1 = strlen(a); len2 = strlen(b);
			printf( "\n  %*s\n+ %*s\n -",
				MAX(len1,len2), a, MAX(len1,len2), b );
			for( i = MAX(len1,len2); i; --i ) putchar( '-' );
			printf( "\n %*s\n", MAX(len1, len2) + 1, buf );
		}while( 1 );
		return 0;
	}

SEE ALSO
	strsub, strmul, strdiv

