
USERSIO			PB-Lib C/C++ Library Programmer's Manual		USERSIO


NAME
	WriteUserBBS - write a record to the USERS.BBS file
	WriteUserPB - write a record to the USERSPB.BBS file
	WriteUserXI - write a record to the USERSXI.BBS file
	WriteUserIDX - write a record to the USERSIDX.BBS file
	ReadUserBBS - read a record from the USERS.BBS file
	ReadUserPB - read a record from the USERSPB.BBS file
	ReadUserXI - read a record from the USERSXI.BBS file
	ReadUserIDX - read a record from the USERSIDX.BBS file

SYNOPSIS
	#include <proutil.h>

	int WriteUserBBS(const USERS *rec, long num);
	int WriteUserPB(const USERSPB *rec, long num);
	int WriteUserXI(const USERSXI *rec, long num);
	int WriteUserIDX(const USERSIDX *rec, long num);
	int ReadUserBBS(USERS *rec, long num);
	int ReadUserPB(USERSPB *rec, long num);
	int ReadUserXI(USERSXI *rec, long num);
	int ReadUserIDX(USERSIDX *rec, long num);

DESCRIPTION
	This is a low-level manipulation of the userbase.  Usage of these
	routines is discouraged.  You should use WriteUser() and ReadUser()
	instead.  They will update and use all the necessary files.  In fact,
	they use the routines in this module.

	In case you need to read/write to only one of the files, you can use
	these functions.  Note that each of the Write() functions will save a
	backup copy of the file it modifies as <filename>.BAK and place it in
	the userbase directory, overwriting any other backup file of that
	name.  Of course, this protection is only limited because if you screw
	up the first write and then do another one, both files are gone.  Be
	very careful with modifying the userbase directly.

	All the record numbering starts at 0, which is consistent with
	ProBoard's way of handling this.

	Note that the RA-compatible files (i.e. all except USERSPB.BBS) use
	Pascal data structures.  This means that strings are incompatible with
	C and that date and time are stored differently.  Also note that the
	access and user flags need remapping too.  This is done internally by
	the ReadUser() and WriteUser() functions which is why you are
	encouraged to use them instead of the ones here.

RETURN VALUE
	On success, these functions return 0 and -1 otherwise.

