
USERSIDX		PB-Lib C/C++ Library Programmer's Manual		USERSIDX


NAME
	MakeUserIndex - create a USERSIDX record for user
	FindUserName - search the userbase index file by name
	FindUserAlias - search the userbase index file by alias

SYNOPSIS
	#include <proutil.h>

	void MakeUserIndex(USERSIDX *rec, const char *name, const char *alias);
	long FindUserName(const char *name);
	long FindUserAlias(const char *alias);

DESCRIPTION
	This package provides an easy means of searching the userbase by name
	or alias.  It utilizes the index file to do extremely fast searches.
	The index file is RA-compatible and consists of records with the name
	and alias 32-bit CRC values (well, quite: see the BUGS section).

	FindUserName() searches the userbase by name.  If successful, this
	function returns the record number of the particular user.  The
	returned value can be used directly with the ReadUser() routine (i.e.,
	record numbering starts at 0, not 1).

	FindUserAlias() is the same as FinduserName() except it does the
	search using the user's alias.

	MakeUserIndex() is a simple way to build the CRC records for the user
	name and alias.  It is provided to shield people from the quirks of
	the CRC calculation required here.

RETURN VALUE
	On success (user found),
		FindUserAlias() and FindUserName() return a long integer with the
		record number for this user (numbering starts at 0).
	On error,
		these functions return -1.

EXAMPLE
	See the exxample program.

BUGS
	RA author's implementation of the 32-bit CRCs has a bug.  For
	compatibility, this bug was carried over to ProBoard.  The thing is,
	the value stored as CRC (and labeled as such) is actually incorrect.
	When you start the calculation, the CRC is initialized to -1 (with the
	algorithm used here) and upon completion, the result is complemented
	with the '~' operator.  This second step is missing in this
	calculation here.  Remember this when you're using the 32-bit CRC
	routines that some in this package:  they return the correct value, so
	you should complement it back before using it with the userbase index.
	All RA-compatible calculations of the CRC have this bug.

SEE ALSO
	crc32.h


