
USERS			PB-Lib C/C++ Library Programmer's Manual		USERS


NAME
	GetNumUsers - get number of users on the system
	ReadUser - create a USER_REC record for user
	WriteUser - write a user record to the userbase
	__writeUserRec - write a user record to the userbase


SYNOPSIS
	#include <proutil.h>

	long GetNumUsers(void);
	int ReadUser(USER_REC *rec, long num);
	void WriteUser(USER_REC *rec);
	int __writeUserRec(const USER_REC *rec);

DESCRIPTION
	This package provides limited userbase manipulation facilities.
	ProBoard's userbase consists of four files.  The three RA-compatible
	files (in Pascal structures):  USERS.BBS, USERSIDX.BBS and USERSXI.BBS
	and the one unique to ProBoard:  USERSPB.BBS.  The three files should
	always be kept synchronized with the record order.  The functions here
	provide the necessary routines to do that.

	Internally, ProBoard maintains a USER_REC record which is filled with
	information from all the userbase files.

	The ReadUser() routine will build this record for user 'num' in the
	userbase.  Note that record numbering starts at 0, not 1.

	WriteUser() will write the USER_REC structure to the userbase.  Since
	the number of the record is kept in the structure, it is not required
	by the function.  Note that if you change this number manually, the
	record will overwrite another one.  Backup copies of the affected
	files are created by this function.

	__writeUserRec() is exactly the same as WriteUser() except it returns
	an integer to indicate success or failure.  Apparently, the SDK's
	WriteUser() blindly assumes that the operation will be successful.

	ReadUser() and WriteUser() are offline versions of the SDK's functions
	with the same names.

	GetNumUsers() returns the number of records in the userbase.  We
	arbitrarily chose to use the USERS.BBS file to retrieve this
	information, but any of the userbase files would do equally well.

	Note that record numbering starts at 0 for all userbase functions, not
	1 as with the other PB-Lib file manipulation routines.  This is a
	peculiarity of ProBoard, not PB-Lib.

RETURN VALUE
	GetNumUsers() returns a long integer with the number of records or -1
	if the function call fails for some reason.

	ReadUser() returns 0 on success and -1 otherwise.

	WriteUser() returns nothing.

	__writeUserRec() returns 0 on success and -1 otherwise.

