
USERDOES		PB-Lib C/C++ Library Programmer's Manual		USERDOES


NAME
	userd_creat - create a UserDoes compatible drop file
	userd_unlink - remove the drop file

SYNOPSIS
	#include <proutil.h>

	int userd_creat(const char *format[, argument, ...]);
	int userd_unlink(void);

DESCRIPTION
	UserDoes is a shareware utility written by Eddie Van Loon of Dqp-Net.
	It shows extended information about the user currently online 9for
	programs that support it).  The support provided here does not
	constitute endorsement of this program, but is a recognition of its
	widespread use and should be treated as an example of cooperation
	where competition does not preclude Sysops from benefits.

	The drop file that UserDoes expects is a simple text file that is
	created in the ProBoard system directory with the name USERDOES.<num>
	where 'num' is the node number that the program is running on.  The
	text of the file should not exceed 22 characters and is the text that
	is displayed by UserDoes.

	userd_creat() uses the printf syntax to format the text string.  It
	will create the file and truncate the text to 22 characters if
	necessary.  On single node systems, the extension will always be 1.
	For offline usage, the extension will always be 1.

	userd_unlink() will remove the drop file.  It is necessary to do so
	before your program exits or UserDoes will become confused.

	You can call userd_creat() at any stage in the program with different
	text strings to indicate various tasks the user is performing.  For
	example, if you have a message reader, you can have message saying the
	user is reading, writing or replying to messages, etc.  Just don't
	forget to call userd_unlink() when your program is about to terminate.

RETURN VALUE
	On success,
		both functions return 0
	On error,
		both functions return -1

