
PBMBASE			PB-Lib C/C++ Library Programmer's Manual		PBMBASE


NAME
	NumMsgAreas - get number of message areas
	ReadMsgArea - read a message area information record
	NumMsgGroups - get number of message groups
	ReadMsgGroup - read a message group information record

SYNOPSIS
	#include <proutil.h>

	int NumMsgAreas(void);
	bool ReadMsgArea(int num, MSGAREA *buf);
	int NumMsgGroups(void);
	int ReadMsgGroup(int num, MSGROUP *buf);

DESCRIPTION
	The NumMsgArea() and ReadMsgArea() are offline versions of the SDK
	functions.  The other two do not have an alternative in the SDK (they
	work both online and offline).

	The Num???() functions do not take into account empty records.
	ProBoard allows you to have records without any information in them.
	The internal NumMsgAreas() does not take those into account either
	(i.e. it simply gives the number of records without actually verifying
	that all records have information stored in them).  An empty record
	will have "\0" as the name string.  You will have to filter those out
	yourself.

	NumMsgAreas() and NumMsgGroups() return the number of message area and
	group records respectively.

	ReadMsgArea() and ReadMsgGroup() fill the area or group structure
	pointed to by 'rec' with information about record 'num'.

RETURN VALUE
	On success,
		NumMsgAreas() and NumMsgGroups() return the number of records
		ReadMsgArea() returns TRUE
		ReadMsgGroup() returns 0
	On error,
		ReadMsgArea() returns FALSE
		All other functions return -1

BUGS
	The ReadMsgArea() function's return value is not consistent with the
	other Read??? functions and with PB-Lib. It returns a boolean value
	whileas the usual is to return 0 or -1.  Since the original SDK
	function has this peculiarity, it was kept here too.

