
PBFINDEX		PB-Lib C/C++ Library Programmer's Manual		PBFINDEX


NAME
	OpenFileIndex - open and prepare the index file for reading
	CloseFileIndex - close index file and flush internal buffers
	RewindFileIndex - position file pointer to the beginning of index
	SearchFileIndex - search file index

SYNOPSIS
	#include <proutil.h>

	int OpenFileIndex(void);
	int CloseFileIndex(void);
	void RewindFileIndex(void);
	int SearchFileIndex(char *match, const char *mask);

DESCRIPTION
	These functions provide an easy interface for doing fast file searches
	by name in ProBoard's filebase.  They utilize the index file in the
	system directory.  The search engine supports extended UNIX-style
	wildcard characters for matching file names.

	OpenFileIndex() prepares the index file and sets up the internal
	structures.  You must call this function before anything else from
	this package or the results are undefined.

	CloseFileIndex() is used when you're done with the file searches.
	This will close the index file and will free any memory allocated
	internally by the package.  You have to call this function upon
	completing the search(es) or the file will stay open and unaccessible
	for the program's duration.

	RewindFileIndex() is used to position the search start point at the
	beginning of the index.  You will rarely need this function because
	when you open the file, the pointer will be placed automatically at
	the beginning of the file.  Use this routine when you need to start a
	new search using the same mask (if you start a search with a new mask,
	the pointer will automatically start at the beginning of the index.)

	SearchFileIndex() is the primary function in the package and is used
	to scan the filebase for filename optionally using wildcards.  The
	'mask' argument is a string containing the mask you want names matched
	against.  This can be any valid MS-DOS filename with or without
	extension and can also contain the following wildcard characters:

		'c'
			normal character, matches the same character (case-sensitive)

		?
			matches any one character (there has to be one)

		*
			matches zero or more characters (longest match)

		[]
			square brackes, matches any of the characters in the set of
			characters included between them. If the first character is
			the circumflex, '^', then matches any character that is not
			in the set between the brackets. You can specify ranges of
			characters, like this [a-zA-Z] for the whole alphabet, or
			[0-9aeyuio] for all digits and the vowels. If the '-' is the
			first or last character in the set, it loses its special
			meaning. For a range to be valid, the first character in it
			must be smaller (syntactically) than the other.

	Note that these differ from the usual MS-DOS meaning and closely mimic
	the UNIX shell environments.  When the function returns, 'match' will
	contain the name of the file that matched the mask and the function's
	return value will be the area it was located in.  Note that 'match'
	points to a user-supplied buffer and therefore should be big enough to
	accomodate the result (which will not exceed 14 characters, including
	the terminating null ('\0') character.)  The returned filename will
	have the form FILENAME.EXT (where .EXT is optional, i.e. it won't be
	there if the file hasn't any).

	Since the matching is case-sensitive, be sure to supply an
	all-uppercase 'mask' argument or else you won't get anything in the
	'match' string (the names in the index file are all uppercase).

	Use successive calls to SearchFileIndex() with NULL as the 'mask'
	parameter to do successive matches for the same pattern.  The function
	will resume scanning from the point it left off at the last call. if
	you want to resume explicitly from the beginning, use
	RewindIndexFile() to do that.  Every time you specify a new 'mask',
	the file pointer will be positioned at the beginning of the index and
	a new search will begin.

RETURN VALUE
	OpenFileIndex() and CloseFileIndex() return 0 on success and -1 if
	anything goes wrong.

	RewindFileIndex() returns nothing.

	SearchFileIndex() returns an area number for the match on success or
	-1 if there are no more matches or if the regular expression supplied
	with the 'mask' argument cannot compile (is invalid).  For valid
	patterns, see the GLOB* documentation.

EXAMPLE
	#include <string.h>
	#include <proutil.h>

	int main( int argc, char *argv[] )
	{
		char mask[BUFSIZ], match[BUFSIZ];

		if( --argc ){
			strcpy( mask, strupr(argv[1]) );
			OpenFileIndex();

			int area = SearchFileIndex( match, mask );
			while( -1 != area ){
				printf( "found '%s' in area %d\n", match, area );
				area = SearchFileIndex( match, NULL );
			}
			CloseFileIndex();
		}
		else printf( "usage: %s <file_mask>", strlwr(*argv) );
		return 0;
	}

