
PBFILE			PB-Lib C/C++ Library Programmer's Manual		PBFILE


NAME
	_mkUserPath - create a path for file in the system directory
	_mkSysPath - create a path for file in the userbase directory
	pbfopen - open a file in the system directory
	usrfopen - open a file in the userbase directory
	UserBackup - backup a file in the userbase directory
	NumFileRecs - get number of records in a typed binary file
	WriteFileRec - write a record to a typed binary file
	ReadFileRec - read a record from a typed binary file

SYNOPSIS
	#include <proutil.h>

	char *_mkSysPath(const char *filename);
	char *_mkUserPath(const char *filename);
	FILE *pbfopen(const char *filename, const char *mode);
	FILE *usrfopen(const char *filename, const char *mode);
	int UserBackup(const char *filename);
	long NumFileRecs(const char *path, size_t width);
	int WriteFileRec(const char *path, long num, void *buf, size_t width);
	int ReadFileRec(const char *path, long num, void *buf, size_t width);

DESCRIPTION
	_mkSysPath() returns a fully-qualified path for 'filename' as if the
	file was in ProBoard's system directory.  For example, to get the full
	pathname for the logfile, you would call _mkSysPath("PROBOARD.LOG")
	and this will return "C:\PB\PROBOARD.LOG", assuming that ProBoard's
	system directory is C:\PB.  The online version depends on an internal
	global variable.  The offline versions depends on the PROBOARD
	environment variable which should be set as per the ProBoard User's
	Guide and Manual.  This function returns a pointer to a static buffer
	which is overwritten by each call.

	_mkUserPath() is similar to _mkSysPath() except it qualifies a
	pathname with regard to the userbase path.  This is done by retrieving
	the information for a global structure (SDK) and reading the
	configuration file (offline).  This function returns a pointer to a
	static buffer which is overwritten by each call.

	pbfopen() and usrfopen() behave exactly as standard library's fopen()
	except the first one will open a file in the system directory and the
	other one - in the userbase directory.  Use the same characters for
	mode as you would for the fopen() function.  Do not give a complete
	path for 'filename', just the name.  The functions will figure out the
	rest.

	UserBackup() will save a copy of file specified in 'filename' in the
	userbase directory.  The new name will be the same, but the extension
	will be changed to ".BAK".  For example, UserBackup("USERS.BBS"); will
	copy the "USERS.BBS" file to "USERS.BAK".

	NumFileRecs() returns the number of records of size 'width' in the
	typed binary file specified in 'path'.

	WriteFileRec() will write a record of size 'width' pointed to by 'buf'
	to position 'num' in the typed binary file specified in 'path'.  Note
	that record numbering starts at 1.  If 'num' is too big, the new
	record is appended to the file.

	ReadFileRec() reads a record of size 'width' into the buffer 'buf'
	from position 'num' in the typed binary file specified in 'path'.
	Note that record numbering starts at 1.  If the record does not exist,
	an error is returned.

RETURN VALUE
	_mk???Path() return a string on success or NULL otherwise.

	pbfopen() and usrfopen() return a pointer to a FILE structure on
	success and NULL otherwise.

	On success, NumFileRecs() returns a long integer, -1 otherwise.

	On success, WriteFileRec() and ReadFileRec() return 0, -1 otherwise.

