
PBFBASE			PB-Lib C/C++ Library Programmer's Manual		PBFBASE


NAME
	NumFileAreas - get number of file areas
	ReadFileArea - read a file area information record
	NumFileGroups - get number of file groups
	ReadFileGroup - read a file group information record

SYNOPSIS
	#include <proutil.h>

	int NumFileAreas(void);
	int ReadFileArea(int num, FILEAREA *buf);
	int NumFileGroups(void);
	int ReadFileGroup(int num, FILEGROUP *buf);

DESCRIPTION
	The NumFileArea() and ReadFileArea() are offline versions of the SDK
	functions.  The other two do not have an alternative in the SDK (they
	work both online and offline).

	The Num???() functions do not take into account empty records.
	ProBoard allows you to have records without any information in them.
	The internal NumFileAreas() does not take those into account either
	(i.e. it simply gives the number of records without actually verifying
	that all records have information stored in them).  An empty record
	will have "\0" as the name string.  You will have to filter those out
	yourself.

	NumFileAreas() and NumFileGroups() return the number of file area and
	group records respectively.

	ReadFileArea() and ReadFileGroup() fill the area or group structure
	pointed to by 'rec' with information about record 'num'.

RETURN VALUE
	On success,
		NumFileAreas() and NumFileGroups() return the number of records
		ReadFileArea() and ReadFileGroup() return 0
	On error all functions return -1


