
MEGANUM			PB-Lib C/C++ Library Programmer's Manual		MEGANUM


NAME
	ltom - converts a long to MegaNum
	mtol - converts a MegaNum to long

SYNOPSIS
	#include <proutil.h>

	char *lotm(long value);
	long mtol(const char *megaNum);

DESCRIPTION
	MegaNum is the name of the base-36 numbers used in RIP programming.
	All numbers in RIP are encoded as MegaNums.  These two functions will
	convert back and forth between the string MegaNums and internal long
	values.

	ltom() will convert a long to a MegaNum. The maximum length of the
	resulting string is 7 characters and has the EOS character appended to
	the end of it.  Note that this function returns a pointer to a static
	buffer which is overwritten by each call.

	mtol() will convert a string MegaNum into a long.  Note that all
	characters in the string are expected to be uppercase or else the
	result will be wrong. No error checking is done.

RETURN VALUE
	ltom() returns pointer to a static buffer with the converted number.
	The maximum length of the resulting string is 7 characters.

	mtol() returns a long integer.

