
INPUT			PB-Lib C/C++ Library Programmer's Manual		INPUT


NAME
	Input - an offline version of SDK's Input() function

SYNOPSIS
	#include <proutil.h>

	void Input(char *buf, int len, int mode);

DESCRIPTION
	Asks for a string from the user. The string is stored in 'buf', and
	the user will not be allowed to enter more than 'len' characters.  For
	'mode', you can use the following constants:

		INPUT_ALL
			All characters are allowed

		INPUT_UPFIRST
			First character of each word is converted to uppercase.

		INPUT_UPALL
			All characters are converted to uppercase.

		INPUT_DIGITS
			Only digits are accepted.

		INPUT_PWD
			OR'ed with any of the above will cause an asterisk ('*') to be
			displayed instead of the character.  (This was undocumented in
			ProBoard SDK's manual, but the original Input() supports it
			too).

		INPUT_NOFIELD
			OR together with any of the previous modes if you don't want
			an input-field background to be displayed.

RETURN VALUE
	None.

