
TIMER			PB-Lib C/C++ Library Programmer's Manual		TIMER


NAME
	timer_start - starts the timer
	timer_stop  - stops the timer
	timer_diff  - returns number of elapsed ticks since last start
	timer_sleep - suspends program execution for number of ticks
	timer_stat  - returns status of timer

SYNOPSIS
	#include <timer.h>

	bool timer_stat(void);
	void timer_start(void);
	void timer_stop(void);
	dword timer_diff(void);
	void timer_sleep(dword ticks);

DESCRIPTION
	The approximate number of ticks per second on a PC is 18.5

	timer_start() starts the timer and resets the start value.

	timer_stop() stops the timer and saves the current timer value.

	timer_diff() returns the number of elapsed ticks since the timer
	was last started. It doesn't stop the timer and the start value of
	the timer is not modified.

	timer_stat() returns 1 if the timer is running and 0 otherwise.

	timer_sleep() suspends program execution for a specified number of
	ticks. The timer is reset at the beginning of waiting. It is not
	stopped afterwards.

EXAMPLE
	#include <timer.h>
	#include <stdio.h>

		void
	main( void )
	{
		printf( "\nStarting timer..." );
		timer_start();
		printf( "\nTicks at start: %lu", __TIMER );

		printf( "\nSleeping for 180 ticks (approx. 10 secs)..." );
		timer_sleep( 180L );
		printf( "\nElapsed time: %lu", timer_diff() );

		printf( "\nTimer running: %s", (timer_stat) ? "Yes" : "No" );
		printf( "\nSleeping for 36 ticks (approx. 2 secs)..." );
		timer_sleep( 36L );

		printf( "\nStopping timer..." );
		timer_stop();

		printf( "\nTicks since start of last sleep: %lu", timer_diff() );

		printf( "\nPress a key to quit." );
		getchar();
	}

