
GETOPT			PB-Lib C/C++ Library Programmer's Manual		GETOPT


NAME
	getopt - extracts command-line arguments

SYNOPSIS
	#include <getopt.h>

	extern int   opterr, optopt, optind;
	extern char *optarg;

	int getopt(int argc, char *argv[], char* opts);

DESCRIPTION
	This is a semi-compatible version of getopt(3) from AT&T's SVR2.

	The getopt function parses the command line arguments. Its arguments
	argc and argv are the argument count and array as passed to the main
	function on program invocation.  opts is a list of available option
	characters. If such a character is followed by a colon, the option
	takes an argument, which is placed in optarg.

	The external variable opterr controls display of error messages. If
	set to 0, messages will be supressed. The default value is 1.

	Optarg points to the parameter for those options that take parameters.
	It also points to the offending string when an error is encountered.

	Optind stores the index of the next option to be processed.

	Optopt holds the last option character found.

	getopt() processes the command-line trying to find options listed in
	the opts array. The search is case-sensitive. If you want getopt()
	to find both cases, you'll need to list them in opts. An option is
	considered everything that starts with '-' or '/', except '--'. When
	an option is found, its value is returned and, if there is one, its
	argument is passed with optarg. getopt() is very lenient about
	whitespace: you can group options that don't take parameters after
	one switch character and you can have the last one in the group with
	a parameter. If a character is not recognized, '?' is returned and
	an optional error message is printed. If an option requires a
	parameter and none is present, '?' is returned and an optional
	error message is printed. If the literal '--' is encountered,
	processing stops and EOF is returned. optind will hold the index of
	the next option that has not been parsed. To see if you have this
	particular case, you can check argc and optind. When there are no
	more options on the command line, EOF is returned.

OPTION SYNTAX
	Options must be preceeded by either '-' or '/'. All options must
	be separated with whitespace. There can be no whitespace between
	the switch character and the option letter. If an option takes a
	parameter, that parameter can follow the option immediately or be
	separated with whitespace. Options that do not take parameters can
	be grouped under one switch character. You can have an option that
	takes a parameter as the last one in that group.

	For example, if you define opts as "ab:Cde:", then the following
	command-lines will produce these results:

	-a -C -b arg -e arg2 -d		recognized: all, b with 'arg', e with 'arg2'
	-aCbarg -de arg2			recognized: all, b with 'arg', e with 'arg2'
	-C -barg					recognized: C and b with 'arg'
	-bC							recognized: b with 'C' as argument
	-b -C						recognized: b with '-C' as argument


RETURN VALUE
	When no more options are left to process, EOF is returned.
	On unknown option error, '?' is returned and optarg points to the
	offending string. On missing parameter error, ':' is returned.
	On success, the option from opts is returned and optarg points to
	its argument, if it takes one.


EXAMPLE
	#include <stdio.h>
	#include <getopt.h>

	void main( int argc, char *argv[] )
	{
		int opt;

		if( 1 == argc ){
			puts( "Usage: %s [-[aC1w]] [-b name] [-R name]\n", argv[0] );
			return;
		}

		while( EOF != (opt = getopt(argc, argv, "aC1wb:r:")) ){
			switch( opt ){
				case 'a':
				case 'C':
				case 'w':
					printf( "Option: '%s'\n", opt );
				break;
				case 'b':
				case 'R':
					printf( "Option: '%c' with arg: '%s'", opt, optarg );
				break;
				case ':':
				case '?':
				return;
				default:
					printf( "A bug: passed this one by: 0c%x!\n", opt );
			}
		}
	}

BUGS
	Long options, permutation and ordering are not supported. This is
	really a stripped-down version of the UNIX getopt and doesn't
	conform to POSIX or anything else. It is quite enough for our
	processing needs.

