
GDLLIST			PB-Lib C/C++ Library Programmer's Manual		GDLLIST


NAME
	gdllist - generic doubly-linked list package

SYNOPSIS
	#include <gdllist.h>

	dlist_t *dlist_new(void);
	void dlist_free( dlist_t *list, void (*ffree)(void *) );
	int dlist_link( dlist_t *list, const void *data, size_t width,
					int where[, int (*fcmp)(const void *, const void *)]);
	void dlist_unlink( dlist_t *list, void *node, void (*ffree)(void *) );
	word dlist_count( dlist_t *list );
	void *dlist_first( dlist_t *list );
	void *dlist_last( dlist_t *list );
	void *dlist_prev( void *curNode );
	void *dlist_next( void *curNode );

CREATING AND DELETING
	The gdllist package implements a generic doubly-linked list structures
	and processing.  The focus is on the dlist_t type list.  This
	structure does not contain any user-accessible fields and should be
	treated as a black box.  All access the the list should be done via
	the provided interface functions.

	Note that the dlist package uses the memory debugging library, so you
	need to have it included and mem_init() called before you start or you
	will get an assertion error.  Also, do not forget to call mem_term()
	at the end of your application to free any memory the debugging
	package was using.  Refer to the MEMDBG documentation for further
	information.

	Before you can use a list, you need to create one.  This is achieved
	with a call to dlist_new().  If this function is successful, it will
	return a pointer to a newly-created list.  If it fails, it will return
	NULL.  You need to check the returned value because all results of the
	dlist_???() functions dealing with an invalid list are undefined.

	To add elements to the list, you use the dlist_link() function.  You
	need to pass it a pointer to a valid list created with a call to
	dlist_new(), a pointer to the data structure you want to add, the size
	(in bytes) of that structure and a constant specifying where you want
	that item added.  The available contants are GDL_START, GDL_END, and
	GDL_SORT. The processing is as follows:

		GDL_START causes the new item to be linked in front of the list.
		If there are no elements in the list, it becomes the first and
		last item.

		GDL_END causes the new item to be linked at the end of the list
		(appended).  If there are no elements in the list, it becomes the
		first and last item.

		GDL_SORT causes the item to be insterted in sorted order in the
		list.  This mode requires an additional argument, the 'fcmp'
		comparison function.  Note that if you want to get a sorted list,
		you have to start using the GDL_SORT mode from the beginning, i.e.
		only the new items are placed in sorted order, the ones already in
		the list will not be checked for order.  If you started building
		the list with any of the other GDL_??? modes, the results are
		undefined.  The comparison function expects pointers to two
		elements to compare, the first one being the item to be inserted.
		It should return values as follows:

			- if elem1 > elem2, integer > 0

			- if the elements are the same, == 0

			- if elem1 < elem2, integer < 0

	To remove an element from the list, you need to call the
	dlist_unlink() function.  It expects a valid 'list', a pointer to the
	node to remove and a pointer to a function to free any additional
	items you might have in the node that need freeing (like other
	pointers).  Note that the 'ffree' functions must not attempt to free
	the node itself, just any additional fields you have allocated
	yourself.  If you don't have such fields, you can pass NULL as the
	ffree parameter.

	To get rid of the whole list, call dlist_free().  You pass it a list
	and a function to deallocate any additional memory in the nodes.
	Refer to the discussion above about the 'ffree' function.  After the
	call to dlist_free(), the list is unusable and should not be
	referenced or used further.

	To get the count of the elements in the list, use the dlist_count()
	function.  It returns an unsigned short integer with the number of
	entries in the list (0 if none).

TRAVERSING
	All traversing functions return a pointer to the element stored in the
	list or NULL if the requested element does not exist.

	To get the first element of the list, use dlist_first().  To get the
	last one, use dlist_last().

	To move back and forth within the list, use dlist_prev() and
	dist_next() respectively.

	For example, to traverse the whole list of integers, you can use a
	construct like the one that follows:

		dlist_t *list = dlist_new();

		 /* assume we have put data in the list */
		for( int *p = dlist_first(list); p; p = dlist_next(p) ){
			/* do your stuff here, p points to an integer */
		}

	Note how the chaining is done with 'p' pointer in dlist_next().  You
	need to be extremely careful when traversing the list like this and
	removing nodes.  After deleting, a node becomes unusable, so pointers
	must be saved for this to work.  Refer to the examples for
	clarification of the algorithm to do that.  Generally, if you do a
	dlist_unlink(list, p, NULL) in the example above, you will be in a lot
	of trouble. What you need to do is something like this:

		for(int *p = dlist_first(list); p; ){
			int *tmp = dlist_next(p);
			dlist_unlink(list, p, NULL);
			p = tmp;
		}

EXAMPLE
	Refer to the GDLTEST?.C examples.

IMPLEMENTATION NOTES
	The dlist_first(), dlist_last(), dlist_next(), dlist_prev() and
	dlist_count() functions are actually implemented as macros.  If you
	need to pass their address to a function, use the functions: they have
	the same names, but prepended with two underscores.

