
FAIL			PB-Lib C/C++ Library Programmer's Manual		FAIL

NAME
	fail - prints an error message and aborts the program
	ffail - logs a message to file, prints it and aborts

SYNOPSIS
	#include <fail.h>

	void fail(const char *format[, argument, ...]);
	void ffail(const char *logfile, const char *format[, argument, ...]);

DESCRIPTION
	fail() prints a message to standard output and aborts the calling
	program with a call to exit().  The format of the message is the same
	as the printf() syntax and you can pass optional arguments to it.
	Refer to the printf() documentation for more information.

	ffail() behaves exactly as fail() except it also logs the message to a
	file specified by the 'logfile' path parameter.  If the file does not
	exist, it is created.  If it does, the message is appended to it.  The
	file is opened in text mode and the format string is dumped to it
	exactly as specified by the caller (with the appropriate printf()
	style substitutions, of course).  You will have to add your own new
	line characters to make sure the file does not consist of one long
	line.  Note that ffail() will both print the message and log it to the
	file.

RETURN VALUE
	Nothing.

EXAMPLE
	#include <stdio.h>
	#include <fail.h>

	void main(void)
	{
		char *name = "INVALID.$$$";

		FILE *fp = fopen( name, "r" );

		if( NULL == fp )
			fail( "%s: could not open '%s' for reading.", *argv, name );
		else fclose(fp);
	}

