

TMPNAME			PB-Lib C/C++ Library Programmer's Manual		TMPNAME



NAME
	tempname - creates a unique file pathname
	tmpname  - creates a unique file pathname in given directory

SYNOPSIS
	#include <fsys.h>

	char *tempname(void);
	char *tmpname(char *path);

DESCRIPTION
	tempname() forms a fully qualified pathname for a unique file. First,
	the TEMP environment variable is tested for a directory path, then
	TMP and, if that fails too, the current directory is attempted. The
	file name will be 8 characters long and is a function of the current
	time. tempname() tries up to 200 times to generate a unique name and
	then gives up. If a unique name is found, tempname checks to see if
	it is possible to create this file. If not, it gives up.

	The file is not actually created, just a name. If you create this file,
	you will be responsible for deleting it when no longer needed.

	For tmpname(), path must be terminated with a backslash. The unique
	name is generated for that directory. Great if you need to duplicate
	a file and rename it later. While rename() lets you have files in
	different directories, you can't have them on separate drives (where
	the TEMP and TMP might point). Creating the file in the same directory
	as the original solves that problem.

RETURN VALUE
	On success, a pointer to a static buffer is returned with the file
	pathname. On error, NULL is returned.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	void
	main( void )
	{
		char *path;

		path = tempname();
		if( !path ) puts( "tempname() failed." );
		else printf( "tempname() returned: %s", path );

		path = tmpname( "C:\\" );
		if( !path ) puts( "tmpname() failed." );
		else printf( "tmpname() returned: %s", path );
	}

ERRORS
	It is possible that tempname is unable to form a path. This can
	happen if, for example, the environment variables point to non-
	existent directories or if they are terminated with a backslash
	(which generally should not be).

	It is possible that tmpname is unable to form a path. This can
	happen if, for example, an invalid path argument is passed to the
	function.

BUGS
	I wanted to use MS-DOS function 0x5a, but for some reason it didn't
	work as advertised: it did create the file, but didn't modify the
	return path argument... Hmmm.. anyway, this tempname should work ok.

