
FGET			PB-Lib C/C++ Library Programmer's Manual		FGET


NAME
	fgetw  - gets a word (unsigned short) from a file
	fgetdw - gets a dword (unsigned long) from a file

SYNOPSIS
	#include <fsys.h>

	word fgetw(FILE *fp);
	dword fgetdw(FILE *fp);

DESCRIPTION
	fgetw() reads a word from the file fp. The caller should have read
	access to the file and the file should be opened for reading.

	fgetdw() reads a dword from the file fp. The caller should have read
	access to the file and the file should be opened for reading.

	Both functions can be used only if the file is opened in binary mode.

	The usefulness of these functions is dubious, since you can read
	values directly without the need of going through all this junk.  They
	are for educational purposes only and should be avoided (slow and
	cumbersome).  They may be dropped from the future versions of the
	library.

RETURN VALUE
	On success the word or dword read is returned.
	On error, -1 or -1L is returned.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	int
	main(int argc, char *argv[])
	{
		FILE *fp;
		dword dw = 0x12345678L, res;

		fp = fopen( "TEST.$$$", "w+b" );
		if( !fp ) return 1;
		fwrite( &dw, sizeof(dw), 1, fp );
		rewind(fp);

		res = fgetdw(fp);
		fclose(fp);
		printf( "0x%lx\n", res );
		return 0;
	}

