

CHMOD			PB-Lib C/C++ Library Programmer's Manual			CHMOD

NAME
	chmod - changes file access mode

SYNOPSIS
	#include <fsys.h>

	int chmod(const char *path, int amode);

DESCRIPTION
	chmod() sets the file access permissions of the file given by 'path'
	according to the mask given in 'amode', which can contain one or both
	of the symbolic constants S_IREAD (permission to read) and S_IWRITE
	(permission to write).  You can or them (S_IREAD | S_IWRITE) for both
	read and write access to the file.

RETURN VALUE
	On success, chmod() returns 0, -1 otherwise.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	void main(int argc, char *argv[])
	{
		/* make executable read-only */
		chmod( *argv, S_IREAD );
	}
