
CHEXT			PB-Lib C/C++ Library Programmer's Manual			CHEXT


NAME
	chext - change (or add) extension of a file name

SYNOPSIS
	#include <fsys.h>

	int chext(char *dest, const char *src, const char *ext);

DESCRIPTION
	chext() changes the extension of the file name specified in 'src' to
	'ext' and returns 'dest'. 'dest' must be big enough to accomodate 'src'
	and, if needed, the new extension. If 'ext' is NULL, the old extension
	is removed. 'ext' must include the period and should not exceed 4
	characters in length. If 'src' does not have an extension, and 'ext'
	is not NULL, the new extension is appended to it. chext recognizes
	both MS-DOS and UNIX-style path separators.

RETURN VALUE
	dest

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	void main(void)
	{
		char buf[81];
		char path[81] = "C:\\SUB.DIR\\ANOTHER\\FILENAME.EXE";
		char ext[5] = ".BAK";

		printf( "Change (%s): %s to %s\n", ext, path, chext(buf,path,ext) );
		strcpy(ext, ".NEW");
		strcpy(path, "C:\\SUB.D\\F");
		printf( "Change (%s): %s to %s\n", ext, path, chext(buf,path,ext) );
		ext[0] = '\0';
		strcpy( path,"FILENAME.EXE" );
		printf( "Change (%s): %s to %s\n", ext, path, chext(buf,path,ext) );
	}

