unit TextUtil;
{ Written by Joe Broms
  Finished May 22, 1994 }

interface

uses Crt,Dos ;

type
    Cursortype = (fullcursor,halfcursor,linecursor,nocursor);

    ScreenPtr = ^ScreenRec ;

    ScreenRec = record
      Pos : array[1..80,1..25] of record
        Ch : char ;
        At : byte ;
      end ; { Pos record }
      Cursx,
      Cursy   : byte ;
    end ; { ScreenRec }

    MenuArray = Array[1..10] of string[80];


var { Golbal }
    VS:           word ;
    BW:           boolean;
    ActiveWin:    ScreenPtr ;

procedure DisplayMessage (S: String);
procedure ReadString (var S: String; X,Y,Size: byte; var Exitcode: byte);
Procedure GetFullChar   (var Ch,Ch2:      Char);
Procedure ClearBuffer;
function  GetAttribute (Fground,Bground: byte): Byte;
procedure ScrollWindow (x1,y1,x2,y2: byte; Number: ShortInt; Attr: byte);
function  GetString (x,y,count: byte): string;
function  GetChar (x,y: byte): char;
procedure DrawScreen (var Screen: ScreenPtr);
procedure LoadScreen (var Screen: ScreenPtr);
procedure SetUpWindows;
procedure ClearBox (x1,y1,x2,y2: byte; color: byte);
procedure WriteStringFilled (S: string; x,y,size,position,attr: byte);
procedure WriteString (S: String; X,Y,Fground,Bground: byte);
procedure WriteCh (Ch: Char; X, Y, Fground, Bground : byte);
procedure DrawBox (X1,Y1,X2,Y2,
                   Fground,
                   Bground,
                   BorderType: Byte);
function  VidSeg : word;
procedure SetCursor (T: CursorType);


implementation

procedure SetCursor (T: CursorType);
{ Written by Joe Broms May 21, 1994 }
{ Changes the cursor size from fullcursor, halfcursor, linecursor, and
  nocursor. }
var Regs: Registers;
begin
  Regs.AH := $01;
  if T = NoCursor
  then begin
    Regs.CH := $20;
    Regs.CL := $20;
  end
  else if T = FullCursor
       then begin
         Regs.CH := $0;
         Regs.CL := $7;
       end
       else if T = LineCursor
            then begin
              Regs.CH := $6;
              Regs.CL := $7;
            end
            else begin
              Regs.CH := $3;
              Regs.CL := $7;
            end;
    Intr ($10,Regs);
end;

function VidSeg : word;
{ Written by Joe Broms May 21, 1994 }
{ Returns correct segment for video memory. }
begin { --- VidSeg --- }
  if Mem[$0000:$04499]=7                                   { Is screen B/W }
  then VidSeg := $B000
  else Vidseg := $B800
end; { --- VidSeg --- }

procedure DrawBox (X1,Y1,X2,Y2,
                   Fground,
                   Bground,
                   BorderType: Byte);
{ Written by Joe Broms May 21, 1994 }
{ draws 5 different boxes }
var i: byte;
begin { --- DrawBox --- }
  if BorderType = 1 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 218;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 191;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 217;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 192;
  end
  else if BorderType = 2 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 201;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 187;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 188;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 200;
  end
  else if BorderType = 3 then
  begin
    for i := X1 to X2 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 220;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 223;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 219;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 219;
    end;
  end
  else if BorderType = 4 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 214;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 183;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 189;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 211;
  end
  else if BorderType = 5 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 213;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 184;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 190;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 212;
  end;
end; { --- DrawBox --- }

procedure WriteCh (Ch: Char; X, Y, Fground, Bground : byte);
{ Written by Joe Broms May 21, 1994 }
{ Writes a character directly to video memory. }
Begin { --- WriteCh --- }
  MemW[VS:((Y-1)*80 + (X-1)) shl 1] :=
             (((Bground shl 4) + Fground) shl 8) + Ord(Ch);
End; { --- WriteCh --- }


procedure WriteString (S: String; X,Y,Fground,Bground: byte);
{ Written by Joe Broms May 21, 1994 }
{ Writes a string directly to video memory. }
var i: byte;
Begin { --- WriteString --- }
  for i := 1 to length(S) do
    MemW[VS:((Y-1)*80+(X+i-2)) shl 1] :=
             (((Bground shl 4) + Fground) shl 8) + Ord(S[i]);
end; { --- WriteString --- }

procedure WriteStringFilled (S: string; x,y,size,position,attr: byte);
{ Written by Joe Broms May 23, 1994 }
{ Writes a string directly to video memory, highlighted.  The string starts
  at X,Y with lenght size.  Position specifies where the characters are
  written. }
var i: byte;
begin
  i := 1;
  while i <> position do
  begin
    insert(' ',s,1);
    inc(i);
  end;
  i := length(s);
  while i <> size do
  begin
    insert(' ',s,length(s)+1);
    inc(i);
  end;
  for i := 1 to length(S) do
    MemW[VS:((Y-1)*80+(X+i-2)) shl 1] := (Attr shl 8)+ Ord(S[i]);
end;


procedure ClearBox (x1,y1,x2,y2: byte; color: byte);
{ Written by Joe Broms May 21, 1994 }
{ Clears a specified box with spaces (#32).  Color is Background color. }
var i,j: byte; { --- ClearBox --- }
begin
  for i := y1 to y2 do
    for j := x1 to x2 do
      MemW[VS:((i-1)*80+(j-1)) shl 1] :=
             (((Color shl 4) + 15) shl 8) + 32;
end; { --- ClearBox --- }

procedure SetUpWindows;
{ Written by Joe Broms May 21, 1994 }
{ Clears the screen. Gets the Correct the video segment.  Allowcates memory
  for the active screen }
Begin  { --- SetUpWindows --- }
  Clrscr;
  VS := VidSeg;                          { Finds the correct video segment }
  New (ActiveWin);                                      { Allowcate memory }
  BW := Mem[$0000:$04499]=7                                { Is screen B/W }
End; { --- SetUpWindows --- }

procedure LoadScreen (var Screen: ScreenPtr);
{ Written by Joe Broms May 21, 1994 }
{ Saves Screen from Active screen.  Must have called the procedure
  SetUpWindows before }
begin { --- Load Screen --- }
  New(Screen);
  ActiveWin := Ptr ($B800,$0000);
  Screen^ := ActiveWin^;
  ActiveWin^ := Screen^;
End; { --- Load Screen --- }

procedure DrawScreen (var Screen: ScreenPtr);
{ Written by Joe Broms May 21, 1994 }
{ Switches Active screen to Screen.  Must have called the procedure
  SetUpWindows before }
Begin { --- DrawScreen --- }
  ActiveWin^ := Screen^;
  Screen^ := ActiveWin^;
End; { --- DrawScreen --- }

function GetChar (x,y: byte): char;
{ Written by Joe Broms May 21, 1994 }
{ Retrieves a character from video memory at X,Y }
var regs: registers;
begin { --- GetChar --- }
  GetChar := Chr(Mem[VS:((Y-1)*80 + (X-1))*2]);
end; { --- GetChar --- }

function GetString (x,y,count: byte): string;
{ Written by Joe Broms May 21, 1994 }
{ Retrieves a string from video memory at X,Y (Count long). }
begin { --- GetString --- }
  GetString[0] := chr(Count);
  while count <> 0 do
  begin
    getstring[Count] := Chr(Mem[VS:((Y-1)*80 + (X+Count-2))*2]);
    Dec(Count);
  end;
end; { --- GetString --- }

procedure ScrollWindow (x1,y1,x2,y2: byte; Number: ShortInt; Attr: byte);
{ Written by Joe Broms May 21, 1994 }
{ Uses the BIOS interupt to scroll a window up or down.  Very Fast!  Number
is the number of line to move up or down.  If number is positive then the
window will scroll down, if negitive then it will scroll up. Attr is the
attribute value to fill the line left over. }
var regs: registers;
begin { --- scrollwindow --- }
  with regs do
  begin
    if Number > 0
    then AH := $07              { scroll window down }
    else AH := $06;             { scroll window up }
    AL := abs(Number);          { number of lines to scroll }
    BH := Attr;                 { attribute to fill empty space }
    CH := y1;
    CL := x1;
    DH := y2;
    DL := x2;
    intr ($10,regs);            { interupt 10h }
  end;
end; { --- scrollwindow --- }

function GetAttribute (Fground,Bground: byte): Byte;
{ Written by Joe Broms May 21, 1994 }
{ Converts two values (Fgorund and Bground) to attribute value. }
begin { --- GetAttribute --- }
  GetAttribute := (Bground shl 4) + (Fground);
end; { --- GetAttribute --- }

Procedure ClearBuffer;
{ Written by Joe Broms May 21, 1994 }
{ Clears the keyboard buffer }
var ch: char;
begin { --- ClearBuffer --- }
  repeat ch := readkey; until not(keypressed);
end; { --- ClearBuffer --- }

Procedure GetFullChar   (var Ch,Ch2:      Char);
{ Written by Joe Broms May 21, 1994 }
{ Use this procedure to handle the keyboard buffer.  If nothing is in the
buffer then ch and ch2 will equal 0.  If a character is pressed then ch will
have the scan code.  If the character is extended (like arrow keys) ch2 will
have the scan code. }
begin { --- GetFullString --- }
  if keypressed                                   { if buffer is not empty }
  then begin
    ch := readkey;                                              { get code }
    if ch = #0                                        { if key is extended }
    then ch2 := readkey                                         { get code }
    else ch2 := #0;                                        { set code to 0 }
  end
  else begin
    ch := #0;                                              { set code to 0 }
    ch2 := #0;                                             { set code to 0 }
  end;
end; { --- GetFullString --- }

procedure ReadString (var S: String; X,Y,Size: byte; var Exitcode: byte);
{ Written by Joe Broms May 22, 1994 }
{ Notes:  1.  Must set S variable to something.  Set it to null '' or a
              string to edit.
          2.  Must have procedures GetFullChar, ClearBox, WriteString
          3.  Exit code is used to see if the user left the procedure on
              escape(1) or return(0).  Add any extra exitcodes as needed.
          4.  Must have called SetUpWindows or assigned VidSeg to VS.
              (VS := VidSeg) }

var ch,ch2:    char;                                 { Keyboard characters }
    CursorAt:  byte;                        { Position of cursor in string }
begin { --- ReadString --- }
  ClearBox (X,Y,X+Size-1,Y,0);             { Clear Space for text in black }
  WriteString (S,X,Y,15,0);                       { Display string to edit }
  CursorAt := 1;                                     { Set cursor at front }
  repeat
    Gotoxy (X+CursorAt-1,Y);              { Set cursor to correct position }
    GetFullChar (ch,ch2);                           { Read keyboard buffer }
    if (ord(ch) + ord(ch2)) <> 0                     { If buffer not empty }
    then begin
      case ch2 of
        #71: CursorAt := 1;                                     { Home key }
        #75: if CursorAt <> 1 then Dec(CursorAt);
                                    { if cursor not in front, move it back }
        #77: if CursorAt <> length(S)+1 then Inc(CursorAt);
                                  { if cursor not in back, move it forward }
        #79: CursorAt := Length(S)+1;                            { End key }
        #83: if (CursorAt-1) <> Length(S)           { if cursor not at end }
             then begin
               Delete (S,CursorAt,1);         { Delete character on cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
             end;
      end;
      case ch of
        #8: if CursorAt <> 1                      { if cursor not in front }
            then begin
               Delete (S,CursorAt-1,1);
                                     { delete character in front of cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
               Dec(CursorAt);                           { move cursor back }
            end;
        else if ((ch <> #0) and (length(s)<size-1) and not(ch in [#27,#13]))
 { if char in buffer,enough room for string and char is not esc and return }
          then begin
            Insert (Ch,S,CursorAt);           { Insert character at cursor }
            WriteString (S,X,Y,15,0);                      { Redraw string }
            Inc(CursorAt);                           { move cursor forward }
          end;
        end;
    end;
  until ch in [#27,#13];                  { Exit block on escape or return }
  if ch = #27
  then ExitCode := 1                                           { If escape }
  else ExitCode := 0;                                          { If Return }
end; { --- ReadString --- }

procedure DisplayMessage (S: String);
var Screen: ScreenPtr;
begin
  LoadScreen (Screen);
  DrawBox (38-(Length(S) div 2),11,42+Length(S) div 2,15,15,0,2);
  ClearBox (39-(Length(S) div 2),12,41+Length(S) div 2,14,0);
  WriteString (S,40-(Length(S) div 2),13,15,0);
  Readln;
  DrawScreen (Screen);
  Dispose (Screen);
end;

end.