program Service_Hour_Program;
{ version 2.0 by Joe Broms }

{$I-}
uses crt, dos, printer;

const
  ConfigFilename = 'Config.Dat';
  BlankLine = '                                                                                ';
  TopMenuText = '     File      Student      Tools      Options      Printer      Help           ';
  HelpFiles: Array[1..20] of String[12] = ('MainMenu.HLP','AddStud.HLP','AutoSave.HLP',
    'Changedr.HLP','','','','','','','','','','','','','','','','');


type FileRecord = Record
       Attr: Word;
       Day,
       Month,
       Year,
       Hour,
       Minute: Word;
       Size: LongInt;
       Name: String[12];
     end;

type
  string80      = string[80];
  string60      = string[60];
  string40      = string[40];
  string25      = string[25];
  string20      = string[20];
  string15      = string[15];
  string12      = string[12];

  ScreenPtr = ^ScreenRec ;

  ScreenRec = record
    Pos : array[1..80,1..25] of record
      Ch : char ;
      At : byte ;
    end ; { Pos record }
    Cursx,
    Cursy   : byte ;
  end ; { ScreenRec }


  MenuRecord = record
    bar:  string80;
    name: string25;
  end;

  MenuArray = Array[1..10] of record
    bar:  string80;
    name: string20;
  end;

  ClassType = (Freshman,Sophomore,Junior,Senior);

  ServiceRecord = Record            { Record for each service preformed
                                      mem = 48 bytes }
    DateMonth,                      {  Month where Jan=1 Feb=2 ... Dec=12 }
    DateYear:       Byte;           { Same mothod as YearOfGrad }
    Descript:       String40;       { Description of Service }
    Time:           Real;           { Amount of time done for service }
  end;

  ServiceArray  = Array[1..25] of ServiceRecord;

  StudentRecord = Record            { Each Student is stored in this record }
    Number:  LongInt;
    LastName:       string15;       { Last name of stuent }
    FirstName:      string15;
    Hours:          Real;
    Class:          Byte;
    Service:        ^ServiceArray;
  end;

  StudentArray = Array[1..300] of ^StudentRecord;

  StudentRecordNP = Record            { Each Student is stored in this record }
    Number:  LongInt;
    LastName:       string15;       { Last name of stuent }
    FirstName:      string15;
    Hours:          Real;
    Class:          Byte;
    Service:        Servicearray;
  end;


  GlobalFilesRecord = Record
    CurrentDir,
    ProgramDir,
    BackupDir,
    HelpDir,
    ClassDir,
    Index,
    Freshman,
    Sophomore,
    Junior,
    Senior:     string60;
  end;

  FileofClass = File of StudentRecordNp;

var Vs:            Word;             { Video Segment }
    ActiveWin:     ScreenPtr;
    MenuArrayText: MenuArray;
    AutosaveOn:    Boolean;
    AutosaveTicks: LongInt;
    AutosaveTime:  LongInt;
    GlobalFiles:   GlobalFilesRecord;
    ActiveClass:   Word;
    SizeOfActiveClass: Word;
    Class: StudentArray;


procedure SetCursor (Num: Byte);
{ Written by Joe Broms May 21, 1994 }
{ Changes the cursor size from fullcursor, halfcursor, linecursor, and
  nocursor. }
var Regs: Registers;
    I: byte;
begin
  Regs.AH := $01;
  if Mem[$0000:$04499]=7                                   { Is screen B/W }
  then I := 0
  else I := 6;
  if Num = 0
  then begin
    Regs.CH := $20;
    Regs.CL := $20;
  end
  else begin
    Regs.CH := $6+I;
    Regs.CL := $7+I;
  end;
  Intr ($10,Regs);
end;

function VidSeg : word;
{ Written by Joe Broms May 21, 1994 }
{ Returns correct segment for video memory. }
begin { --- VidSeg --- }
  if Mem[$0000:$04499]=7                                   { Is screen B/W }
  then VidSeg := $B000
  else Vidseg := $B800
end; { --- VidSeg --- }

procedure DrawBox (X1,Y1,X2,Y2,
                   Fground,
                   Bground,
                   BorderType: Byte);
{ Written by Joe Broms May 21, 1994 }
{ draws 5 different boxes }
var i: byte;
begin { --- DrawBox --- }
  if BorderType = 1 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 218;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 191;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 217;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 192;
  end
  else if BorderType = 2 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 201;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 187;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 188;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 200;
  end
  else if BorderType = 3 then
  begin
    for i := X1 to X2 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 220;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 223;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 219;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 219;
    end;
  end
  else if BorderType = 4 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 196;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 186;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 214;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 183;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 189;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 211;
  end
  else if BorderType = 5 then
  begin
    for i := X1+1 to X2-1 do
    begin
      MemW[VS:((Y1-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
      MemW[VS:((Y2-1)*80+i-1)*2] := (((Bground shl 4) + Fground) shl 8) + 205;
    end;
    for i := Y1+1 to Y2-1 do
    begin
      MemW[VS:((i-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
      MemW[VS:((i-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 179;
    end;
    MemW[VS:((Y1-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 213;
    MemW[VS:((Y1-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 184;
    MemW[VS:((Y2-1)*80+X2-1)*2] := (((Bground shl 4) + Fground) shl 8) + 190;
    MemW[VS:((Y2-1)*80+X1-1)*2] := (((Bground shl 4) + Fground) shl 8) + 212;
  end;
end; { --- DrawBox --- }

procedure WriteCh (Ch: Char; X, Y, Fground, Bground : byte);
{ Written by Joe Broms May 21, 1994 }
{ Writes a character directly to video memory. }
Begin { --- WriteCh --- }
  MemW[VS:((Y-1)*80 + (X-1))*2] :=
             (((Bground shl 4) + Fground) shl 8) + Ord(Ch);
End; { --- WriteCh --- }


procedure WriteString (S: String; X,Y,Fground,Bground: byte);
{ Written by Joe Broms May 21, 1994 }
{ Writes a string directly to video memory. }
var i: byte;
Begin { --- WriteString --- }
  for i := 1 to length(S) do
    MemW[VS:((Y-1)*80+(X+i-2)) shl 1] :=
             (((Bground shl 4) + Fground) shl 8) + Ord(S[i]);

end; { --- WriteString --- }

procedure WriteStringFilled (S: string; x,y,size,position,attr: byte);
{ Written by Joe Broms May 23, 1994 }
{ Writes a string directly to video memory, highlighted.  The string starts
  at X,Y with lenght size.  Position specifies where the characters are
  written. }
var i: byte;
begin
  i := 1;
  while i <> position do
  begin
    insert(' ',s,1);
    inc(i);
  end;
  i := length(s);
  while i <> size do
  begin
    insert(' ',s,length(s)+1);
    inc(i);
  end;
  for i := 1 to length(S) do
    MemW[VS:((Y-1)*80+(X+i-2)) shl 1] := (Attr shl 8)+ Ord(S[i]);
end;


procedure ClearBox (x1,y1,x2,y2: byte; color: byte);
{ Written by Joe Broms May 21, 1994 }
{ Clears a specified box with spaces (#32).  Color is Background color. }
var i,j: byte; { --- ClearBox --- }
begin
  for i := y1 to y2 do
    for j := x1 to x2 do
      MemW[VS:((i-1)*80+(j-1)) shl 1] :=
             (((Color shl 4) + 15) shl 8) + 32;
end; { --- ClearBox --- }

procedure SetUpWindows;
{ Written by Joe Broms May 21, 1994 }
{ Clears the screen. Gets the Correct the video segment.  Allowcates memory
  for the active screen }
Begin  { --- SetUpWindows --- }
  Clrscr;
  VS := VidSeg;                          { Finds the correct video segment }
  New (ActiveWin);                                      { Allowcate memory }
End; { --- SetUpWindows --- }

procedure LoadScreen (var Screen: ScreenPtr);
{ Written by Joe Broms May 21, 1994 }
{ Saves Screen from Active screen.  Must have called the procedure
  SetUpWindows before }
begin { --- Load Screen --- }
  New(Screen);
  ActiveWin := Ptr (VidSeg,$0000);
  Screen^ := ActiveWin^;
End; { --- Load Screen --- }

procedure DrawScreen (var Screen: ScreenPtr);
{ Written by Joe Broms May 21, 1994 }
{ Switches Active screen to Screen.  Must have called the procedure
  SetUpWindows before }
Begin { --- DrawScreen --- }
  ActiveWin^ := Screen^;
End; { --- DrawScreen --- }

function GetChar (x,y: byte): char;
{ Written by Joe Broms May 21, 1994 }
{ Retrieves a character from video memory at X,Y }
var regs: registers;
begin { --- GetChar --- }
  GetChar := Chr(Mem[VS:((Y-1)*80 + (X-1))*2]);
end; { --- GetChar --- }

function GetString (x,y,count: byte): string;
{ Written by Joe Broms May 21, 1994 }
{ Retrieves a string from video memory at X,Y (Count long). }
begin { --- GetString --- }
  GetString[0] := chr(Count);
  while count <> 0 do
  begin
    getstring[Count] := Chr(Mem[VS:((Y-1)*80 + (X+Count-2))*2]);
    Dec(Count);
  end;
end; { --- GetString --- }

procedure ScrollWindow (x1,y1,x2,y2: byte; Number: ShortInt; Attr: byte);
{ Written by Joe Broms May 21, 1994 }
{ Uses the BIOS interupt to scroll a window up or down.  Very Fast!  Number
is the number of line to move up or down.  If number is positive then the
window will scroll down, if negitive then it will scroll up. Attr is the
attribute value to fill the line left over. }
var regs: registers;
begin { --- scrollwindow --- }
  with regs do
  begin
    if Number > 0
    then AH := $07              { scroll window down }
    else AH := $06;             { scroll window up }
    AL := abs(Number);          { number of lines to scroll }
    BH := Attr;                 { attribute to fill empty space }
    CH := y1;
    CL := x1;
    DH := y2;
    DL := x2;
    intr ($10,regs);            { interupt 10h }
  end;
end; { --- scrollwindow --- }

function GetAttribute (Fground,Bground: byte): Byte;
{ Written by Joe Broms May 21, 1994 }
{ Converts two values (Fgorund and Bground) to attribute value. }
begin { --- GetAttribute --- }
  GetAttribute := (Bground shl 4) + (Fground);
end; { --- GetAttribute --- }

Procedure ClearBuffer;
{ Written by Joe Broms May 21, 1994 }
{ Clears the keyboard buffer }
var ch: char;
begin { --- ClearBuffer --- }
  repeat ch := readkey; until not(keypressed);
end; { --- ClearBuffer --- }

Procedure GetFullChar   (var Ch,Ch2:      Char);
{ Written by Joe Broms May 21, 1994 }
{ Use this procedure to handle the keyboard buffer.  If nothing is in the
buffer then ch and ch2 will equal 0.  If a character is pressed then ch will
have the scan code.  If the character is extended (like arrow keys) ch2 will
have the scan code. }
begin { --- GetFullString --- }
  if keypressed                                   { if buffer is not empty }
  then begin
    ch := readkey;                                              { get code }
    if ch = #0                                        { if key is extended }
    then ch2 := readkey                                         { get code }
    else ch2 := #0;                                        { set code to 0 }
  end
  else begin
    ch := #0;                                              { set code to 0 }
    ch2 := #0;                                             { set code to 0 }
  end;
end; { --- GetFullString --- }

procedure ReadString (var S: String; X,Y,Size: byte; var Exitcode: byte);
{ Written by Joe Broms May 22, 1994 }
{ Notes:  1.  Must set S variable to something.  Set it to null '' or a
              string to edit.
          2.  Must have procedures GetFullChar, ClearBox, WriteString
          3.  Exit code is used to see if the user left the procedure on
              escape(1) or return(0).  Add any extra exitcodes as needed.
          4.  Must have called SetUpWindows or assigned VidSeg to VS.
              (VS := VidSeg) }

var ch,ch2:    char;                                 { Keyboard characters }
    CursorAt:  byte;                        { Position of cursor in string }
begin { --- ReadString --- }
  ClearBox (X,Y,X+Size-1,Y,0);             { Clear Space for text in black }
  WriteString (S,X,Y,15,0);                       { Display string to edit }
  CursorAt := 1;                                     { Set cursor at front }
  repeat
    Gotoxy (X+CursorAt-1,Y);              { Set cursor to correct position }
    GetFullChar (ch,ch2);                           { Read keyboard buffer }
    if (ord(ch) + ord(ch2)) <> 0                     { If buffer not empty }
    then begin
      case ch2 of
        #71: CursorAt := 1;                                     { Home key }
        #75: if CursorAt <> 1 then Dec(CursorAt);
                                    { if cursor not in front, move it back }
        #77: if CursorAt <> length(S)+1 then Inc(CursorAt);
                                  { if cursor not in back, move it forward }
        #79: CursorAt := Length(S)+1;                            { End key }
        #83: if (CursorAt-1) <> Length(S)           { if cursor not at end }
             then begin
               Delete (S,CursorAt,1);         { Delete character on cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
             end;
      end;
      case ch of
        #8: if CursorAt <> 1                      { if cursor not in front }
            then begin
               Delete (S,CursorAt-1,1);
                                     { delete character in front of cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
               Dec(CursorAt);                           { move cursor back }
            end;
        else if ((ch <> #0) and (length(s)<size-1) and not(ch in [#27,#13]))
 { if char in buffer,enough room for string and char is not esc and return }
          then begin
            Insert (Ch,S,CursorAt);           { Insert character at cursor }
            WriteString (S,X,Y,15,0);                      { Redraw string }
            Inc(CursorAt);                           { move cursor forward }
          end;
        end;
    end;
  until ch in [#27,#13];                  { Exit block on escape or return }
  if ch = #27
  then ExitCode := 1                                           { If escape }
  else ExitCode := 0;                                          { If Return }
end; { --- ReadString --- }

procedure ReadString2 (var S: String; X,Y,Size: byte; var Exitcode: byte);
{ Written by Joe Broms May 22, 1994 }
{ Notes:  1.  Must set S variable to something.  Set it to null '' or a
              string to edit.
          2.  Must have procedures GetFullChar, ClearBox, WriteString
          3.  Exit code is used to see if the user left the procedure on
              escape(1) or return(0).  Add any extra exitcodes as needed.
          4.  Must have called SetUpWindows or assigned VidSeg to VS.
              (VS := VidSeg)
          5.  Will exit with exitcode 2 or 3 if up or down arrow is pressed }

var ch,ch2:    char;                                 { Keyboard characters }
    CursorAt:  byte;                        { Position of cursor in string }
begin { --- ReadString --- }
  ClearBox (X,Y,X+Size-1,Y,0);             { Clear Space for text in black }
  WriteString (S,X,Y,15,0);                       { Display string to edit }
  CursorAt := 1;                                     { Set cursor at front }
  repeat
    Gotoxy (X+CursorAt-1,Y);              { Set cursor to correct position }
    GetFullChar (ch,ch2);                           { Read keyboard buffer }
    if (ord(ch) + ord(ch2)) <> 0                     { If buffer not empty }
    then begin
      case ch2 of
        #71: CursorAt := 1;                                     { Home key }
        #75: if CursorAt <> 1 then Dec(CursorAt);
                                    { if cursor not in front, move it back }
        #77: if CursorAt <> length(S)+1 then Inc(CursorAt);
                                  { if cursor not in back, move it forward }
        #79: CursorAt := Length(S)+1;                            { End key }
        #83: if (CursorAt-1) <> Length(S)           { if cursor not at end }
             then begin
               Delete (S,CursorAt,1);         { Delete character on cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
             end;
      end;
      case ch of
        #8: if CursorAt <> 1                      { if cursor not in front }
            then begin
               Delete (S,CursorAt-1,1);
                                     { delete character in front of cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
               Dec(CursorAt);                           { move cursor back }
            end;
        else if ((ch <> #0) and (length(s)<size-1) and not(ch in [#27,#13]))
 { if char in buffer,enough room for string and char is not esc and return }
          then begin
            Insert (Ch,S,CursorAt);           { Insert character at cursor }
            WriteString (S,X,Y,15,0);                      { Redraw string }
            Inc(CursorAt);                           { move cursor forward }
          end;
        end;
    end;
  until (ch in [#27,#13]) or (ch2 in [#72,#80]);                  { Exit block on escape or return }
  if ch = #13 then ExitCode := 0;                                 { If Return }
  if ch = #27 then ExitCode := 1;                                 { If escape }
  if ch2 = #72 then ExitCode := 2;                                { If up arrow }
  if ch2 = #80 then ExitCode := 3;                                { If down arrow }
end; { --- ReadString --- }

procedure ReadString3 (var S: String; X,Y,Size: byte; var Exitcode: byte);
{ Written by Joe Broms May 22, 1994 }
{ Notes:  1.  Must set S variable to something.  Set it to null '' or a
              string to edit.
          2.  Must have procedures GetFullChar, ClearBox, WriteString
          3.  Exit code is used to see if the user left the procedure on
              escape(1) or return(0).  Add any extra exitcodes as needed.
          4.  Must have called SetUpWindows or assigned VidSeg to VS.
              (VS := VidSeg)
          5.  Will exit with exitcode 2 or 3 if up or down arrow is pressed }

var ch,ch2:    char;                                 { Keyboard characters }
    CursorAt:  byte;                        { Position of cursor in string }
begin { --- ReadString --- }
  ClearBox (X,Y,X+Size-1,Y,0);             { Clear Space for text in black }
  WriteString (S,X,Y,15,0);                       { Display string to edit }
  CursorAt := 1;                                     { Set cursor at front }
  repeat
    Gotoxy (X+CursorAt-1,Y);              { Set cursor to correct position }
    GetFullChar (ch,ch2);                           { Read keyboard buffer }
    if (ord(ch) + ord(ch2)) <> 0                     { If buffer not empty }
    then begin
      case ch2 of
        #71: CursorAt := 1;                                     { Home key }
        #75: if CursorAt <> 1 then Dec(CursorAt);
                                    { if cursor not in front, move it back }
        #77: if CursorAt <> length(S)+1 then Inc(CursorAt);
                                  { if cursor not in back, move it forward }
        #79: CursorAt := Length(S)+1;                            { End key }
        #83: if (CursorAt-1) <> Length(S)           { if cursor not at end }
             then begin
               Delete (S,CursorAt,1);         { Delete character on cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
             end;
      end;
      case ch of
        #8: if CursorAt <> 1                      { if cursor not in front }
            then begin
               Delete (S,CursorAt-1,1);
                                     { delete character in front of cursor }
               WriteString (S+' ',X,Y,15,0);               { Redraw string }
               Dec(CursorAt);                           { move cursor back }
            end;
        else if ((ch in [#48..#57]) and (length(s)<size-1) and not(ch in [#27,#13]))
 { if char in buffer,enough room for string and char is not esc and return }
          then begin
            Insert (Ch,S,CursorAt);           { Insert character at cursor }
            WriteString (S,X,Y,15,0);                      { Redraw string }
            Inc(CursorAt);                           { move cursor forward }
          end;
        end;
    end;
  until (ch in [#27,#13]) or (ch2 in [#72,#80]);                  { Exit block on escape or return }
  if ch = #13 then ExitCode := 0;                                 { If Return }
  if ch = #27 then ExitCode := 1;                                 { If escape }
  if ch2 = #72 then ExitCode := 2;                                { If up arrow }
  if ch2 = #80 then ExitCode := 3;                                { If down arrow }
end; { --- ReadString --- }

procedure StatusLine (Line: String80);
begin
  WriteStringFilled (Line,1,25,80,2,$70);
end;




procedure FillScreen (Ch: Char;  FColor,BColor: byte);
var x,y: byte;
begin
  for y := 1 to 80 do
    for x := 1 to 80 do
      MemW[VS:((Y-1)*80+(X-2)) shl 1] :=
         (((BColor shl 4) + FColor) shl 8) + Ord(Ch);
end;

procedure ChangeColors (x1,y1,x2,y2,FColor,BColor: byte);
var x,y: byte;
begin
  for y := y1 to y2 do
    for x := x1 to x2 do
      MemW[VS:((Y-1)*80+(X-2)) shl 1] :=
         (((BColor shl 4) + FColor) shl 8) + Mem[VS:((Y-1)*80+(X-2)) shl 1];
end;

procedure MakeFakeBox (Title: String; x1,y1,x2,y2,Fcolor,BColor: byte);
{ Draws a box, clears inside the box, and puts a title and fake mouse buton
  thingy on top of box }
var i: byte;
begin
  DrawBox (x1,y1,x2,y2,Fcolor,Bcolor,2);
  ClearBox (x1+1,y1+1,x2-1,y2-1,BColor);
  if Title <> '' then
  begin
    WriteString ('[]',x1+2,y1,FColor,BColor);
    WriteString (' '+Title+' ',((x1+x2) div 2) - (length(Title) div 2)-1,y1,FColor,BColor);
  end;
  if (y2 < 24) and (x2 < 79) then ChangeColors (x1+3,y2+1,x2+3,y2+1,7,0);
  if (y2 < 24) and (x2 = 79) then ChangeColors (x1+3,y2+1,x2+2,y2+1,7,0);
  if (y2 < 24) and (x2 = 80) then ChangeColors (x1+3,y2+1,x2+1,y2+1,7,0);
  if (x2 < 79) then ChangeColors (x2+2,y1+1,x2+3,y2,7,0);
  if (x2 = 79) then ChangeColors (x2+2,y1+1,x2+2,y2,7,0);
end;


procedure DisplayMessage (S: String);
var Screen: ScreenPtr;
    Ch: Char;
begin
  LoadScreen (Screen);
  MakeFakeBox ('Error',37-(Length(S) div 2),11,42+Length(S) div 2,15,15,0);
  WriteString (S,40-(Length(S) div 2),13,15,0);
  StatusLine ('Press any key to continue');
  Repeat
  Until keypressed;
  GetFullChar (Ch,Ch);
  DrawScreen (Screen);
  Dispose (Screen);
end;

function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  if Length(s) > 2 then S := S[Length(s)-1] + S[Length(s)];
  LeadingZero := s;
end;


function MakeLongTimeDateString (Year,Month,Day,Hour,Minute: Word): String;
Const MonthString : Array[1..12] of String[20] = ('January','Februray',
  'March','April','May','June','July','August','September','October',
  'November','December');
var NumString,Temp: String;
begin
  Str(Year,NumString);
  Temp := MonthString[Month]+' '+LeadingZero(Day)+', '+NumString
   +'  ';
  If Hour < 13
  Then Temp := Temp + Leadingzero(Hour)+':'+Leadingzero(Minute)+'am'
  Else Temp := Temp + Leadingzero(Hour-12)+':'+Leadingzero(Minute)+'pm';
  MakeLongTimeDateString := Temp;
end;


function MakeTimeDateString (Year,Month,Day,Hour,Minute: Word): String;
begin
  MakeTimeDateString := LeadingZero(Month)+'/'+
                        LeadingZero(Day)+'/'+
                        LeadingZero(Year)+'   '+
                        LeadingZero(Hour)+':'+
                        LeadingZero(Minute);
end;

function FileExists(Filename: Pathstr): Boolean;
var F: file of byte;
begin
  assign (F,Filename);
  reset (F);
  If IOresult = 0
  then begin
    FileExists := TRUE;
    Close (F);
  end
  else FileExists := FALSE;
end;

procedure GetFileInfo(Filename: PathStr; var Info: FileRecord);
var F: File of Byte;
    Path,Name,Ext: String;
    Time: Longint;
    Dt: Datetime;
begin
  assign (F,Filename);
  reset (F);
  If IOresult = 0
  then begin
    Info.Size := FileSize(F);
    GetFTime (F,Time);
    UnpackTime (Time,DT);
    Info.Year   := DT.Year;
    Info.Month  := DT.Month;
    Info.Day    := DT.Day;
    Info.Hour   := DT.Hour;
    Info.Minute := DT.Min;
    GetFAttr (F,Info.Attr);
    FSplit(Filename,Path,Name,Ext);
    Info.Name := Name+Ext;
    Close (F);
  end
end;

procedure SearchForAFile (filename: string12);

procedure FileSearch (Path: Pathstr;Filename: string12);
var S: SearchRec;
begin
  FindFirst('*.*',AnyFile,S);
  If (S.Name = Filename) and (S.Attr <> Directory)       { File is found! }
    then writeln ('Found at ',Path);
{ Is it a directory and not . or .. }
  If (S.Attr = Directory) and not((S.Name = '.') or (S.Name = '..'))
  then begin
    ChDir (Path+'\'+S.Name);                            { Change directory }
    Filesearch(Path+'\'+S.Name,Filename);          { Search that directory }
  end;
  Findnext(S);
  While DosError = 0 do
  begin
    If (S.Name = Filename) and (S.Attr <> Directory)
      then writeln ('Found at ',Path);                  { File is found! }
{ Is it a directory and not . or .. }
    If (S.Attr = Directory) and not((S.Name = '.') or (S.Name = '..'))
      then begin
        ChDir (Path+'\'+S.Name);                       { Change directory }
        Filesearch(Path+'\'+S.Name,Filename);     { Search that directory }
      end;
    Findnext(S);
  end;
  DosError := 0;
end;
var Dir: String;
begin
  GetDir (0,Dir);
  ChDir (Copy(Dir,1,3));
  FileSearch(Copy(Dir,1,2),Filename);
  ChDir (Dir);
end;


function DirectoryValid (Path: PathStr):boolean;
var dir: pathstr;
begin
  getdir(0,dir);
  chdir(path);
  DirectoryValid := IOresult = 0;
  chdir(dir);
end;

procedure WriteClass (filename: string; var class: StudentArray);
var f: file of StudentRecord;
    i: word;
begin
  assign(f,filename);
  reset(f);
  i := 0;
  while (i <> 300) and (class[i] <> nil)
  do begin
    write(f,class[i+1]^);
    inc(i);
  end;
  close(f);
end;

procedure DestroyClassMem (var class: StudentArray);
var i: word;
begin
  for i := 1 to 300 do if class[i] <> nil then dispose(class[i]);
end;

procedure ReadClass (filename: string; var class: StudentArray);
var f: file of studentRecord;
    i: word;
begin
  assign(f,filename);
  rewrite(f);
  i := 1;
  while (not(eof(f))) and (i <> 300) do
  begin
    new(Class[i]);
    read(f,Class[i]^);
    inc(i);
  end;
  close(f);
end;

Procedure CreateClassFile (Filename: string);
var f: file of studentrecord;
begin
  assign(f,filename);
  rewrite(f);
  close(f);
end;




procedure IntroCredits;
var Screen: ScreenPtr;
    Ch,Ch2: char;
begin
  LoadScreen (Screen);
  MakeFakeBox ('About',25,7,55,19,15,0);
  WriteString ('Service Hour Database',30,9,15,0);
  WriteString ('Version 2.0',35,11,15,0);
  WriteString ('by Joseph Broms',33,13,15,0);
  WriteString ('Broms Software (c) 1994',29,15,15,0);
  WriteString ('Press any key to continue',28,17,15,0);
  repeat until keypressed;
  ClearBuffer;
  DrawScreen (Screen);
  Dispose (Screen);
end;







procedure FileMenu (var Selection: byte);
var M:   Array[1..6] of MenuRecord;
    Ch,
    Ch2: Char;
    I:   Byte;
    Screen:   ScreenPtr;
    LastSelection: Byte;
begin
  M[1].Name := 'Load class...';
  M[1].Bar  := 'Load an entire class';
  M[2].Name := 'Load student...';
  M[2].Bar  := 'Load one student';
  M[3].Name := 'Search & load...';
  M[3].Bar  := 'Search for selected students, then load them';
  M[4].Name := 'Save work';
  M[4].Bar  := 'Save work';
  M[5].Name := 'Save & close work';
  M[5].Bar  := 'Save & close work';
  M[6].Name := 'Exit program';
  M[6].Bar  := 'Save work and exit program';
  WriteStringFilled ('File',3,1,10,4,$0F);
  LoadScreen (Screen);
  MakeFakeBox ('',3,2,25,9,15,0);
  LastSelection := 0;
  Repeat
    if LastSelection <> Selection then
    For i := 1 to 6 do
      if i = Selection
        then begin
          WriteStringFilled (M[i].name,4,i+2,21,3,$70);
          StatusLine (M[i].Bar);
        end
        else WriteStringFilled (M[i].name,4,i+2,21,3,$0F);
    LastSelection := Selection;
    GetFullChar (Ch,Ch2);
    case ch2 of
      #72: Dec(Selection);
      #80: Inc(Selection);
    end;
    If Selection = 0 then Selection := 6;
    If Selection = 7 then Selection := 1;
  Until (Ch in [#13,#27]) or (Ch2 in [#75,#77]);
  DrawScreen (Screen);
  Dispose (Screen);
  if Ch  = #27 then Selection := 253;
  if Ch2 = #75 then Selection := 254;
  if Ch2 = #77 then Selection := 255;
end;


procedure StudentMenu (var Selection: byte);
var M:   Array[1..3] of MenuRecord;
    Ch,
    Ch2: Char;
    I:   Byte;
    Screen:   ScreenPtr;
    LastSelection: Byte;
begin
  M[1].Name := 'Add student...';
  M[1].Bar  := 'Add a new student';
  M[2].Name := 'Delete student';
  M[2].Bar  := 'Delete student from the class';
  M[3].Name := 'Edit attributes';
  M[3].Bar  := 'Edit name, year, or student ID number';
  LoadScreen (Screen);
  WriteStringFilled ('Student',13,1,13,4,$0F);
  MakeFakeBox ('',13,2,33,6,15,0);
  LastSelection := 0;
  Repeat
    if LastSelection <> Selection then
    For i := 1 to 3 do
      if i = Selection
        then begin
          WriteStringFilled (M[i].name,14,i+2,19,3,$70);
          StatusLine (M[i].Bar);
        end
        else WriteStringFilled (M[i].name,14,i+2,19,3,$0F);
    LastSelection := Selection;
    GetFullChar (Ch,Ch2);
    case ch2 of
      #72: Dec(Selection);
      #80: Inc(Selection);
    end;
    If Selection = 0 then Selection := 3;
    If Selection = 4 then Selection := 1;
  Until (Ch in [#13,#27]) or (Ch2 in [#75,#77]);
  DrawScreen (Screen);
  Dispose (Screen);
  if Ch  = #27 then Selection := 253;
  if Ch2 = #75 then Selection := 254;
  if Ch2 = #77 then Selection := 255;
end;



procedure ToolsMenu (var Selection: byte);
var M:   Array[1..3] of MenuRecord;
    Ch,
    Ch2: Char;
    I:   Byte;
    Screen:   ScreenPtr;
    LastSelection: Byte;
begin
  M[1].Name := 'Quick Entry...';
  M[1].Bar  := 'Enter service hours for any class';
  M[2].Name := 'Search...';
  M[2].Bar  := 'Find a student';
  M[3].Name := 'Sort...';
  M[3].Bar  := 'Sort a file or active work';
  LoadScreen (Screen);
  WriteStringFilled ('Tools',26,1,11,4,$0F);
  MakeFakeBox ('',26,2,45,6,15,0);
  LastSelection := 0;
  Repeat
    if LastSelection <> Selection then
    For i := 1 to 3 do
      if i = Selection
        then begin
          WriteStringFilled (M[i].name,27,i+2,18,3,$70);
          StatusLine (M[i].Bar);
        end
        else WriteStringFilled (M[i].name,27,i+2,18,3,$0F);
    LastSelection := Selection;
    GetFullChar (Ch,Ch2);
    case ch2 of
      #72: Dec(Selection);
      #80: Inc(Selection);
    end;
    If Selection = 0 then Selection := 3;
    If Selection = 4 then Selection := 1;
  Until (Ch in [#13,#27]) or (Ch2 in [#75,#77]);
  DrawScreen (Screen);
  Dispose (Screen);
  if Ch  = #27 then Selection := 253;
  if Ch2 = #75 then Selection := 254;
  if Ch2 = #77 then Selection := 255;
end;

procedure OptionsMenu (var Selection: byte);
var M:   Array[1..7] of MenuRecord;
    Ch,
    Ch2: Char;
    I:   Byte;
    Screen:   ScreenPtr;
    LastSelection: Byte;
begin
  M[1].Name := 'Screen Saver...';
  M[1].Bar  := 'Change settings for screen saver';
  M[2].Name := 'Auto-save...';
  M[2].Bar  := 'Change settings for auto-save';
  M[3].Name := 'Directories...';
  M[3].Bar  := 'Set defult directories';
  M[4].Name := 'Printer...';
  M[4].Bar  := 'Set printer options';
  M[5].Name := 'Load Freshman...';
  M[5].Bar  := 'Load Freshman from Osiris';
  M[6].Name := 'Yearly Update...';
  M[6].Bar  := 'Shift class up a year';
  M[7].Name := 'Zip/Unzip files...';
  M[7].Bar  := 'Compress and Uncompress any or all files with PKZIP(tm)';
  LoadScreen (Screen);
  WriteStringFilled ('Options',37,1,13,4,$0F);
  MakeFakeBox ('',37,2,60,10,15,0);
  LastSelection := 0;
  Repeat
    if LastSelection <> Selection then
    For i := 1 to 7 do
      if i = Selection
        then begin
          WriteStringFilled (M[i].name,38,i+2,22,3,$70);
          StatusLine (M[i].Bar);
        end
        else WriteStringFilled (M[i].name,38,i+2,22,3,$0F);
    LastSelection := Selection;
    GetFullChar (Ch,Ch2);
    case ch2 of
      #72: Dec(Selection);
      #80: Inc(Selection);
    end;
    If Selection = 0 then Selection := 7;
    If Selection = 8 then Selection := 1;
  Until (Ch in [#13,#27]) or (Ch2 in [#75,#77]);
  DrawScreen (Screen);
  Dispose (Screen);
  if Ch  = #27 then Selection := 253;
  if Ch2 = #75 then Selection := 254;
  if Ch2 = #77 then Selection := 255;
end;

procedure PrinterMenu (var Selection: byte);
var M:   Array[1..5] of MenuRecord;
    Ch,
    Ch2: Char;
    I:   Byte;
    Screen:   ScreenPtr;
    LastSelection: Byte;
begin
  M[1].Name := 'Printer commands...';
  M[1].Bar  := 'Form feed, Line feed, Test printer';
  M[2].Name := 'Print work...';
  M[2].Bar  := 'Print all students in memory';
  M[3].Name := 'Print student.';
  M[3].Bar  := 'Print entire class';
  M[4].Name := 'Search & Print...';
  M[4].Bar  := 'Print selected students';
  M[5].Name := 'Print services';
  M[5].Bar  := 'Print list of services';
  LoadScreen (Screen);
  WriteStringFilled ('Printer',50,1,13,4,$0F);
  MakeFakeBox ('',50,2,74,8,15,0);
  LastSelection := 0;
  Repeat
    if LastSelection <> Selection then
    For i := 1 to 5 do
      if i = Selection
        then begin
          WriteStringFilled (M[i].name,51,i+2,23,3,$70);
          StatusLine (M[i].Bar);
        end
        else WriteStringFilled (M[i].name,51,i+2,23,3,$0F);
    LastSelection := Selection;
    GetFullChar (Ch,Ch2);
    case ch2 of
      #72: Dec(Selection);
      #80: Inc(Selection);
    end;
    If Selection = 0 then Selection := 5;
    If Selection = 6 then Selection := 1;
  Until (Ch in [#13,#27]) or (Ch2 in [#75,#77]);
  DrawScreen (Screen);
  Dispose (Screen);
  if Ch  = #27 then Selection := 253;
  if Ch2 = #75 then Selection := 254;
  if Ch2 = #77 then Selection := 255;
end;

procedure HelpMenu (var Selection: byte);
var M:   Array[1..5] of MenuRecord;
    Ch,
    Ch2: Char;
    I:   Byte;
    Screen:   ScreenPtr;
    LastSelection: Byte;
begin
  M[1].Name := 'Getting started';
  M[1].Bar  := 'Getting started';
  M[2].Name := 'Contents...';
  M[2].Bar  := 'Table of contents';
  M[3].Name := 'Last Topic';
  M[3].Bar  := 'Go to last help screen';
  M[4].Name := 'Help on Help';
  M[4].Bar  := 'Help on Help';
  M[5].Name := 'About';
  M[5].Bar  := 'Show version and copywright information';
  LoadScreen (Screen);
  WriteStringFilled ('Help',63,1,10,4,$0F);
  MakeFakeBox ('',60,2,80,8,15,0);
  LastSelection := 0;
  Repeat
    if LastSelection <> Selection then
    For i := 1 to 5 do
      if i = Selection
        then begin
          WriteStringFilled (M[i].name,61,i+2,19,3,$70);
          StatusLine (M[i].Bar);
        end
        else WriteStringFilled (M[i].name,61,i+2,19,3,$0F);
    LastSelection := Selection;
    GetFullChar (Ch,Ch2);
    case ch2 of
      #72: Dec(Selection);
      #80: Inc(Selection);
    end;
    If Selection = 0 then Selection := 5;
    If Selection = 6 then Selection := 1;
  Until (Ch in [#13,#27]) or (Ch2 in [#75,#77]);
  DrawScreen (Screen);
  Dispose (Screen);
  if Ch  = #27 then Selection := 253;
  if Ch2 = #75 then Selection := 254;
  if Ch2 = #77 then Selection := 255;
end;



procedure MainMenuTop (var Selection,MenuDownSelection: Byte);
var M:   Array[1..6] of MenuRecord;
    Screen: ScreenPtr;
    I,
    LastSelection: byte;

    Ch,Ch2: char;
begin
  M[1].Name := 'File';
  M[1].Bar  := 'File management commands (Load, Save, ect.)';
  M[2].Name := 'Student';
  M[2].Bar  := 'Student editing commands (New, Delete, Edit, ect.)';
  M[3].Name := 'Tools';
  M[3].Bar  := 'Search, sorting, and quick entry functions';
  M[4].Name := 'Options';
  M[4].Bar  := 'Set defults & use special commands';
  M[5].Name := 'Printer';
  M[5].Bar  := 'Print and set printer options';
  M[6].Name := 'Help';
  M[6].Bar  := 'Get online help';
  LoadScreen (Screen);
  WriteString (TopMenuText,1,1,0,7);
  LastSelection := 0;
  Repeat
    if LastSelection <> Selection then  { Check to see if menu must be changed }
    For i := 1 to 6 do
      if i = Selection
        then begin
          Case i of
            1:  WriteStringFilled (M[1].name,3, 1,10,4,$0F);
            2:  WriteStringFilled (M[2].name,13,1,13,4,$0F);
            3:  WriteStringFilled (M[3].name,26,1,11,4,$0F);
            4:  WriteStringFilled (M[4].name,37,1,13,4,$0F);
            5:  WriteStringFilled (M[5].name,50,1,13,4,$0F);
            6:  WriteStringFilled (M[6].name,63,1,10,4,$0F);
          end;
          StatusLine (M[i].Bar);
        end
        else
          Case i of
            1:  WriteStringFilled (M[1].name,3, 1,10,4,$70);
            2:  WriteStringFilled (M[2].name,13,1,13,4,$70);
            3:  WriteStringFilled (M[3].name,26,1,11,4,$70);
            4:  WriteStringFilled (M[4].name,37,1,13,4,$70);
            5:  WriteStringFilled (M[5].name,50,1,13,4,$70);
            6:  WriteStringFilled (M[6].name,63,1,10,4,$70);
          end;
    LastSelection := Selection;
    GetFullChar (Ch,Ch2);                               { if keypressed, return codes }
    case ch2 of
      #75: Dec(Selection);                              { move menu left }
      #77: Inc(Selection);                              { move menu right }
    end;
    If Selection = 0 then Selection := 6;               { wrap menu }
    If Selection = 7 then Selection := 1;               { wrap menu }

  Until ((upcase(Ch) in [#13,#27,'S','F','H','P','T','O'])) or (Ch2 = #80);
                                       { if down arrow, return, or escape }
  case upcase(Ch) of
    'F': Selection := 1;
    'S': Selection := 2;
    'T': Selection := 3;
    'O': Selection := 4;
    'P': Selection := 5;
    'H': Selection := 6;
  end;

  if Ch <> #27                                          { If not escape }
  then
  begin
    Repeat
      StatusLine ('');
      WriteString (TopMenuText,1,1,0,7);

      MenuDownSelection := 1;
      Case Selection of
        1: FileMenu    (MenuDownSelection);
        2: StudentMenu (MenuDownSelection);
        3: ToolsMenu   (MenuDownSelection);
        4: OptionsMenu (MenuDownSelection);
        5: PrinterMenu (MenuDownSelection);
        6: HelpMenu    (MenuDownSelection);
      end;
      Case MenuDownSelection of
        254: Dec (Selection);
        255: Inc (Selection);
      end;
      if Selection = 0 then Selection := 6;
      if Selection = 7 then Selection := 1;
    Until not (MenuDownSelection in [254..255]);
  end;
  DrawScreen (Screen);
  Dispose (Screen);
  if (MenuDownSelection = 253) then Selection := 0;
end;

procedure CheckBox (On,Active: Boolean; X,Y,Size,Position: Byte);
begin
  if On and Active
  then begin
    ChangeColors (X,Y,X+Size-1,Y,0,7);
    WriteCh ('X',X+Position-1,Y,0,7);
  end
  else if Not(On) and Active
       then begin
         ChangeColors (X,Y,X+Size-1,Y,7,0);
         WriteCh ('X',X+Position-1,Y,7,0);
       end
       else if On and Not(Active)
            then begin
              ChangeColors (X,Y,X+Size-1,Y,0,7);
              WriteCh (' ',X+Position-1,Y,0,7);
            end
            else if Not(On) and Not(Active)
                 then begin
                   ChangeColors (X,Y,X+Size-1,Y,7,0);
                   WriteCh (' ',X+Position-1,Y,7,0);
                 end;
end;

procedure ActionBox (On: Boolean; X,Y,Size: Byte);
begin
  if On
    then ChangeColors (X,Y,X+Size-1,Y,0,7)
    else ChangeColors (X,Y,X+Size-1,Y,7,0);
end;

procedure RadioBox (Cursor,AT,X,Y,SizeDown,SizeAcross,Position: Byte);
var i: byte;
begin
  for i := 1 to SizeDown do
  begin
  if (i = At) and not(i = cursor)
  then begin
    ChangeColors (X,Y+i-1,X+SizeAcross-1,Y+i-1,7,0);
    WriteCh (#7,X+Position-1,Y+i-1,7,0);
  end
  else if (i = At) and (i = cursor)
       then begin
         ChangeColors (X,Y+i-1,X+SizeAcross-1,Y+i-1,0,7);
         WriteCh (#7,X+Position-1,Y+i-1,0,7);
       end
       else if not(i = At) and not(i = cursor)
            then begin
              ChangeColors (X,Y+i-1,X+SizeAcross-1,Y+i-1,7,0);
              WriteCh (' ',X+Position-1,Y+i-1,7,0);
            end
            else if Not(i = At) and (i = cursor)
                 then begin
                   ChangeColors (X,Y+i-1,X+SizeAcross-1,Y+i-1,0,7);
                   WriteCh (' ',X+Position-1,Y+i-1,0,7);
                 end;
  end;
end;

Procedure HelpSystem (Num: byte);
var
  screen: screenptr;
  ch,ch2: char;
  f: text;
  last,
  max,i,
  current: byte;
  helptext: array[1..150] of string[60];
  title: string;
begin
  loadscreen (screen);
  current := 1;
  assign(f,HelpFiles[Num]);
  reset(f);
  readln (f,title);
  makefakebox (title,19,3,62,23,15,0);
  max := 0;
  while not(eof(f)) do
  begin
    inc(max);
    readln (f,helptext[max]);
  end;
  close (f);
  StatusLine (' Press <UP>, <DOWN>, <PGUP>, <PGDN>, <HOME>, <END>, <ESC>');
  last := 0;
  repeat
    getfullchar (ch,ch2);
    case ch2 of
      #71: Current := 1;
      #72: Dec(Current);
      #73: Dec(Current,17);
      #79: Current := Max-17;
      #80: Inc(Current);
      #81: Inc(Current,17);
    end;
    if current < 1 then current := 1;
    if (current+17 > max) and (max>17) then current := Max-17;
    if current <> last then
    if max < 18 then for i := 1 to max do writestringfilled (HelpText[i],21,4+i,40,2,$07)
                else for i := 1 to 17  do writestringfilled (HelpText[i+current-1],21,4+i,40,2,$07);
    last := current;

  until ch = #27;
  drawscreen (screen);
  dispose (screen);
end;


procedure GetAutoSave;
var ch,ch2: char;
    Screen: ScreenPtr;
    LastSelection,
    Select: byte;
    At: Byte;
    Help,
    Ok,
    Cancel,
    On: boolean;
begin
  Help := FALSE;
  Ok := False;
  On := AutosaveOn;
  Cancel := False;
  Select := 1;
  At := AutosaveTime;
  LoadScreen (Screen);
  MakeFakeBox ('Auto-save',26,6,57,20,15,0);
  WriteString ('[ ] Auto-Save',           32,8,15, 0);
  WriteString ('Time: ( )  5 minutes',    32,10,15, 0);
  WriteString ('      ( ) 10 minutes',    32,11,15, 0);
  WriteString ('      ( ) 20 minutes',    32,12,15, 0);
  WriteString ('      ( ) 30 minutes',    32,13,15, 0);
  WriteString ('      ( ) 1 hour',        32,14,15, 0);
  WriteString ('[Save Changes]',          32,16,15, 0);
  WriteString ('[Cancel]',                32,17,15, 0);
  WriteString ('[Help]',                  32,18,15, 0);
  repeat
    getfullchar (ch,ch2);
    case ch2 of
      #80: inc (Select);
      #72: dec (Select);
    end;
    if select = 0 then select := 9;
    if select = 10 then select := 1;
    if (ch = #13) or (ch = #32) then
    case Select of
      1: On := Not(On);  { <----- Slick }
      2: At := 1;
      3: At := 2;
      4: At := 3;
      5: At := 4;
      6: At := 5;
      7: Ok := True;
      8: Cancel := True;
      9: Help := True;
    end;
    if ch = #27 then Cancel := True;
    if LastSelection <> Select
    then
      CheckBox (Select=1,On,32,8,15,2);
      RadioBox (Select-1,At,38,10,5,16,2);
      ActionBox (Select=7,32,16,16);
      ActionBox (Select=8,32,17,10);
      ActionBox (Select=9,32,18,8);
      Case Select of
        1:  StatusLine (' F1 Help  Turn auto-save on/off');
        2:  StatusLine (' F1 Help  Change time to 5 minutes');
        3:  StatusLine (' F1 Help  Change time to 10 minutes');
        4:  StatusLine (' F1 Help  Change time to 20 minutes');
        5:  StatusLine (' F1 Help  Change time to 30 minutes');
        6:  StatusLine (' F1 Help  Change time to 1 hour');
        7:  StatusLine (' F1 Help  Save changes');
        8:  StatusLine (' F1 Help  Leave without making changes');
        9:  StatusLine (' F1 Help  Help on auto save');

    end;
  if help then
  begin
    HelpSystem (3);
    Help := False;
  end;
  until ok or cancel;
  if ok then
  begin
  Case at of
    1: begin
         AutoSaveTime := 1;
         AutoSaveTicks := 5460;
       end;
    2: begin
         AutoSaveTime := 2;
         AutoSaveTicks := 10920;
       end;
    3: begin
         AutoSaveTime := 3;
         AutoSaveTicks := 21840;
       end;
    4: begin
         AutoSaveTime := 4;
         AutoSaveTicks := 32760;
       end;
    5: begin
         AutoSaveTime := 5;
         AutoSaveTicks := 65520;
       end;
     end;
    AutoSaveOn := On;
    StatusLine ('Auto-save defults changed.')
  end
  else StatusLine ('Auto-save not changed.');
  DrawScreen (Screen);
  Dispose (Screen);
end;


function WordtoString (Num: Word): String;
var temp: string;
begin Str(Num,temp); WordtoString := temp; end;

function BytetoString (Num: Byte): String;
var temp: string;
begin Str(Num,temp); BytetoString := temp; end;

function LongInttoString (Num: LongInt): String;
var temp: string;
begin Str(Num,temp); LongInttoString := temp; end;

function RealtoString (Num: Real): String;
var temp: string;
begin Str(Num,temp); RealtoString := temp; end;

function Real2toString (Num: Real): String;
var temp: string;
begin Str(Num:0:2,temp); Real2toString := temp; end;


procedure QuickSort(Lo, Hi: Integer);

procedure Sort(l, r: Integer);
var
  i, j: integer;
  x: string;
  y: studentrecord;
begin
  i := l; j := r; x := Class[(l+r) DIV 2]^.lastname;
  repeat
    while class[i]^.lastname < x do i := i + 1;
    while x < class[j]^.lastname do j := j - 1;
    if i <= j then
    begin
      y := class[i]^; class[i]^ := class[j]^; class[j]^ := y;
      i := i + 1; j := j - 1;
    end;
  until i > j;
  if l < j then Sort(l, j);
  if i < r then Sort(i, r);
end;

begin {QuickSort};
  Sort(Lo,Hi);
end;

procedure EditStudent1 (Selection,Classnum: Word);
var StudentScreen: ScreenPtr;
    F: File Of StudentRecordNP;
    OneStudent: StudentRecordNP;
    S: String;
begin
  LoadScreen (studentScreen);
  MakeFakeBox (class[selection]^.firstname+class[selection]^.lastname,5,5,75,20,15,0);
  case ClassNum of
    1: assign(f,globalfiles.freshman);
    2: assign(f,globalfiles.sophomore);
    3: assign(f,globalfiles.junior);
    4: assign(f,globalfiles.senior);
  end;
  reset(f);
  seek(f,Selection-1);
  read(f,OneStudent);
  close(f);

  class[selection]^.FirstName := OneStudent.Firstname;
  class[selection]^.LastName  := OneStudent.LastName;
  class[selection]^.Number    := OneStudent.Number;
  class[selection]^.Hours     := OneStudent.Hours;
  writestring ('Last Name:   ',7,7,7,0);
  writestring (class[selection]^.lastname,20,7,15,0);
  writestring ('First Name:  ',40,7,7,0);
  writestring (class[selection]^.firstname,55,7,15,0);
  writestring ('Id Number:   ',7,8,7,0);
  writestring (LongIntToString(class[selection]^.number),20,8,15,0);
  writestring ('Total Hours: ',40,8,7,0);
  Str(class[selection]^.hours:0:2,s);
  S := S + ' hours';
  writestring (S,55,8,15,0);
  writeString ('[ Service Information ]Ķ',5,10,15,0);
  readln;
  DrawScreen(studentScreen);
  Dispose(studentscreen);
end;


procedure LoadClass;
var ch, ch2: char;
    lastselection,selection, current: integer;
    studentscreen,screen,percentScreen: screenptr;
    f: file of StudentRecordNP;
    OneStudent: StudentRecordNP;
    Student: StudentRecord;
    classnum,i,j: word;
    s,s1,s2: string;
    size: longint;
    exist: array[1..4] of boolean;

begin
  for i := 1 to 300 do
    Class[i] := nil;
  loadscreen(screen);
  makefakebox ('Load Class',5,5,75,17,15,0);
  WriteString ('Class       Filename       In Directory?       # of Records',9,6,7,0);
  WriteString ('Ķ',5,7,15,0);
  Writestring ('Freshman  ',9,9,7,0);
  Writestring ('Sophomore ',9,11,7,0);
  Writestring ('Junior    ',9,13,7,0);
  Writestring ('Senoir    ',9,15,7,0);
  Writestring (GlobalFiles.Freshman,21,9,7,0);
  Writestring (GlobalFiles.Sophomore,21,11,7,0);
  Writestring (GlobalFiles.Junior,21,13,7,0);
  Writestring (GlobalFiles.Senior,21,15,7,0);

  Exist[1] := Fileexists (GlobalFiles.Freshman);
  Exist[2] := Fileexists (GlobalFiles.Sophomore);
  Exist[3] := Fileexists (GlobalFiles.Junior);
  Exist[4] := Fileexists (GlobalFiles.Senior);

  if Exist[1]
  then begin
    writestring ('Yes',36,9,7,0);
    Assign (F,GlobalFiles.Freshman);
    Reset (F);
    Size := FileSize(F);
    Str(Size,S);
    WriteString (S,56,9,7,0);
    Close(F);
  end
  else writestring ('No',36,9,7,0);

  if Exist[2]
  then begin
    writestring ('Yes',36,11,7,0);
    Assign (F,GlobalFiles.Sophomore);
    Reset (F);
    Size := FileSize(F);
    Str(Size,S);
    WriteString (S,56,11,7,0);
    Close(F);
  end
  else writestring ('No',36,11,7,0);

  if Exist[3]
  then begin
    writestring ('Yes',36,13,7,0);
    Assign (F,GlobalFiles.Junior);
    Reset (F);
    Size := FileSize(F);
    Str(Size,S);
    WriteString (S,56,13,7,0);
    Close(F);
  end
  else writestring ('No',36,13,7,0);

  if Exist[4]
  then begin
    writestring ('Yes',36,15,7,0);
    Assign (F,GlobalFiles.Senior);
    Reset (F);
    Size := FileSize(F);
    Str(Size,S);
    WriteString (S,56,15,7,0);
    Close(F);
  end
  else writestring ('No',36,15,7,0);

  Selection := 1;
  LastSelection := 2;
  repeat
    getfullchar (ch,ch2);
    case ch2 of
      #72: Dec(Selection);
      #80: Inc(Selection);
    end;
    if Selection = 0 then Selection := 4;
    if Selection = 5 then Selection := 1;
    if LastSelection <> Selection then
    for i := 1 to 4
    do if i = selection
       then ChangeColors (8,i*2+7,74,i*2+7,0,7)
       else ChangeColors (8,i*2+7,74,i*2+7,7,0);
    LastSelection := Selection;

  until (ch = #27) or ((ch = #13) and Exist[Selection]);
  DrawScreen(Screen);

  if ch = #13 then begin
  case Selection of
    1: begin
         assign(f,GlobalFiles.Freshman);
         makefakebox ('Freshman Class',12,2,68,24,15,0);
       end;
    2: begin
         assign(f,GlobalFiles.Sophomore);
         makefakebox ('Sophomore Class',12,2,68,24,15,0);
       end;
    3: begin
         assign(f,GlobalFiles.Junior);
         makefakebox ('Junior Class',12,2,68,24,15,0);
       end;
    4: begin
         assign(f,GlobalFiles.Senior);
         makefakebox ('Senior Class',12,2,68,24,15,0);
       end;
  end;
  ClassNum := Selection;
  writech ('',68,3,0,7);
  writech ('',68,23,0,7);
    for i := 4 to 22 do
      writech ('',68,i,0,7);


  reset(f);
  i := 0;
  loadscreen (percentscreen);
  makefakebox ('Loading Class...',3,7,78,15,15,0);

  str(Filesize(f),s);
  writestring ('Records Loaded: ',7,9,7,0);
  writestring ('                0                                              '+s,7,10,7,0);

  writestring ('Memory Avail:',7,12,7,0);
  writestring ('',23,12,15,0);
  writestring ('                0 K                                          640 K',7,13,7,0);

  while not(eof(f)) and not(Memavail < 4000) do
    begin
      inc(i);
      read(f,onestudent);
      For j := 1 to round(i / filesize(f) * 50)
        do WriteString ('',22+j,9,15,0);
      For j := 50 downto round(MemAvail/655360*50)
        do WriteString ('',j+22,12,7,0);
      new(class[i]);
      str(i,s);
      writestring (s+' ',8,10,15,0);
      str(Memavail,s);
      writestring (s+' ',8,13,15,0);
      class[i]^.lastname := onestudent.lastname;
      class[i]^.firstname := onestudent.firstname;
      class[i]^.number := onestudent.number;
      class[i]^.hours := onestudent.hours;
    end;
  Size := FileSize(F);
  close(f);
  drawscreen (percentscreen);
  dispose(percentscreen);
  quicksort(1,Size);
  selection := 1;
  lastselection := 0;
  current := 1;
  statusline ('F1 Help  Scroll Up & Down, Enter for Detail');
  repeat
    getfullchar (ch,ch2);
    case ch2 of
      #80: Inc(Selection);
      #81: Inc(Selection,20);
      #72: Dec(Selection);
      #73: Dec(Selection,20);
      #71: selection := 0;
      #79: selection := 30000;

    end;
    if selection < 1 then selection := 1;
    if selection > Size then selection := Size;
    if (current < selection - 20) then current := selection - 20;
    if (current > selection) then current := selection;

{    if ch = #13 then EditStudent1 (Selection,ClassNum);}

    if selection <> lastselection
    then
    begin
    if Size > 21
    then for i := 1 to 21 do
      if selection = i+current-1
      then writestringfilled (class[i+current-1]^.lastname+'  '+
           class[i+current-1]^.firstname+'  '+
           longintToString(class[i+current-1]^.Number)+'      '+
           real2ToString(class[i+current-1]^.Hours)+'   ',13,i+2,55,3,$70)
      else writestringfilled (class[i+current-1]^.lastname+'  '+
           class[i+current-1]^.firstname+'  '+
           longintToString(class[i+current-1]^.Number)+'      '+
           real2ToString(class[i+current-1]^.Hours)+'   ',13,i+2,55,3,$07)
    else for i := 1 to Size do
      if selection = i+current-1
      then writestring (class[i+current-1]^.lastname+'  '+
           class[i+current-1]^.firstname+'  '+
           longintToString(class[i+current-1]^.Number)+'      '+
           real2ToString(class[i+current-1]^.Hours)+'   ',16,i+2,0,7)
      else writestring (class[i+current-1]^.lastname+'  '+
           class[i+current-1]^.firstname+'  '+
           longintToString(class[i+current-1]^.Number)+'      '+
           real2ToString(class[i+current-1]^.Hours)+'   ',16,i+2,7,0);

    for i := 4 to 22 do
      if i-4 = round(Selection/Size*18)
      then writech ('',68,i,15,0)
      else writech ('',68,i,7,0);

  end;
    lastselection := selection;
  until ch = #27;
  drawscreen (screen);
  dispose (screen);
  i := 1;
  while (i <> 301) and (class[i] <> nil) do begin
     dispose(class[i]);
     inc(i);
  end;
  end;
end;




procedure Fillin (S:String80;X,Y,Size: Byte);
begin
  WriteStringFilled (S,X,Y,Size,2,$07);
end;


procedure ChangeDirectories;
var ch, ch2: char;
    exitcode,
    lastselection,
    selection: byte;

    screen: screenptr;
    help,
    search,
    ok,
    cancel,
    defualt:boolean;

begin
  loadscreen(screen);
  makefakebox ('Change Directories',1,2,80,24,15,0);
  writestring ('Directories',10,4,15,0);
  writestring ('  Program     :',10,5,15,0);
  writestring ('  Classes     :',10,6,15,0);
  writestring ('  Backup      :',10,7,15,0);
  writestring ('  Help        :',10,8,15,0);

  writestring ('Class Files',10,11,15,0);
  writestring ('  Freshman    :',10,12,15,0);
  writestring ('  Sophomore   :',10,13,15,0);
  writestring ('  Junior      :',10,14,15,0);
  writestring ('  Senior      :',10,15,15,0);
  writestring ('  Index       :',10,16,15,0);

  writestring ('[Save changes]     [Cancel]     [Help]',10,20,15,0);
  writestring ('[Load Defualts]    [Search]',10,22,15,0);

  WriteString (GlobalFiles.CurrentDir,27,5,15,0);
  WriteString (GlobalFiles.ClassDir,  27,6,15,0);
  WriteString (GlobalFiles.BackupDir, 27,7,15,0);
  WriteString (GlobalFiles.HelpDir,   27,8,15,0);
  WriteString (GlobalFiles.Freshman,  27,12,15,0);
  WriteString (GlobalFiles.Sophomore,  27,13,15,0);
  WriteString (GlobalFiles.Junior,    27,14,15,0);
  WriteString (GlobalFiles.Senior,    27,15,15,0);
  WriteString (GlobalFiles.Index,     27,16,15,0);

  selection := 1;
  ok := false;
  help := false;
  cancel := false;
  defualt := false;
  lastselection := 0;
  repeat
    getfullchar (ch,ch2);
    if ch = #27 then cancel := true;
    if ch2 = #72 then dec(selection);
    if ch2 = #80 then inc(selection);
    if selection > 14 then selection := 1;
    if selection < 1 then selection := 14;
    if lastselection <> selection
    then
    begin
      ActionBox (Selection=1,11,5,13);
      ActionBox (Selection=2,11,6,13);
      ActionBox (Selection=3,11,7,13);
      ActionBox (Selection=4,11,8,13);
      ActionBox (Selection=5,11,12,13);
      ActionBox (Selection=6,11,13,13);
      ActionBox (Selection=7,11,14,13);
      ActionBox (Selection=8,11,15,13);
      ActionBox (Selection=9,11,16,13);
      ActionBox (Selection=10,10,20,16);
      ActionBox (Selection=11,29,20,10);
      ActionBox (Selection=12,42,20,8);
      ActionBox (Selection=13,10,22,17);
      ActionBox (Selection=14,29,22,10);
      Case selection of
        1:  StatusLine (' F1 Help  Program Directory');
        2:  StatusLine (' F1 Help  Class Directory');
        3:  StatusLine (' F1 Help  Directory with PKZIP(c) and PKUNZIP(c)');
        4:  StatusLine (' F1 Help  Directory with help files (.HLP)');
        5:  StatusLine (' F1 Help  Freshman class (.DAT)');
        6:  StatusLine (' F1 Help  Sophomore class (.DAT)');
        7:  StatusLine (' F1 Help  Junior class (.DAT)');
        8:  StatusLine (' F1 Help  Senoir class (.DAT)');
        9:  StatusLine (' F1 Help  Index of school (.IND)');
        10:  StatusLine (' F1 Help  Save Changes');
        11:  StatusLine (' F1 Help  Leave without saving changes');
        12:  StatusLine (' F1 Help  Get help');
        13:  StatusLine (' F1 Help  Load defualts from installation');
        14:  StatusLine (' F1 Help  Search for directories and files');
      end;
    end;
    lastselection := selection;
    if ch = #13
    then begin
      SetCursor (1);
      case selection of
        1: ReadString (GlobalFiles.CurrentDir,27,5,40,Exitcode);
        2: ReadString (GlobalFiles.ClassDir,  27,6,40,Exitcode);
        3: ReadString (GlobalFiles.BackupDir, 27,7,40,Exitcode);
        4: ReadString (GlobalFiles.HelpDir,   27,8,40,Exitcode);
        5: ReadString (GlobalFiles.Freshman,  27,12,12,Exitcode);
        6: ReadString (GlobalFiles.Sophomore,  27,13,12,Exitcode);
        7: ReadString (GlobalFiles.Junior,    27,14,12,Exitcode);
        8: ReadString (GlobalFiles.Senior,    27,15,12,Exitcode);
        9: ReadString (GlobalFiles.Index,     27,16,12,Exitcode);
        10: Ok := TRUE;
        11: Cancel := TRUE;
        12: Help := TRUE;
        13: Defualt := TRUE;
        14: Search := TRUE;
      end;
      SetCursor (0);
    end;
  if Help or (Ch2 = #59) then
  begin
    HelpSystem (4);
    Help := False;
  end;

  until ok or cancel;
  drawscreen (screen);
  dispose (screen);
end;






Procedure Init_Student (var S: StudentRecord);
var W: Word;
begin
  S.FirstName := '';
  S.LastName  := '';
  S.Hours     := 0;
  S.Number    := 0;
end;



Procedure Add_Student (var S: StudentRecord);
var Screen: ScreenPtr;
    NumberErrorCode: integer;
    I,
    ExitCode,
    LastSelection,
    Selection: Byte;
    IdNum: String[8];
    Ch,Ch2: char;
    At: byte;
    MoveDown,
    Ok,Cancel,Help: Boolean;
    Classfile: string;
    f: file of StudentRecord;
    Stud: StudentRecord;
begin
  Init_Student (S);
  IDNum := '';
  loadscreen (screen);
  makefakebox ('Add Student',15,6,65,20,15,0);
  WriteString ('Last Name   [                ]',25,8,7,0);
  WriteString ('First Name  [                ]',25,9,7,0);
  WriteString ('Id Number   [         ]',25,11,7,0);
  WriteString (S.LastName,38,8,15,0);
  WriteString (S.FirstName,38,9,15,0);
{  Str (S.Number,IdNum);}
  WriteString (IdNum,38,11,15,0);
  WriteString ('Class  ( ) Freshman',30,13,7,0);
  WriteString ('       ( ) Sophmore',30,14,7,0);
  WriteString ('       ( ) Junior',30,15,7,0);
  WriteString ('       ( ) Senior',30,16,7,0);
  WriteString ('[Add]        [Cancel]        [Help]',22,18,7,0);
  lastselection := 0;
  selection := 1;
  at := 1;
  exitcode := 0;
  movedown := False;
  Help  := FALSE;
  Ok     := FALSE;
  Cancel := FALSE;
  Repeat
    GetFullChar (Ch,Ch2);
    Case Ch2 of
      #72,#75: Dec(Selection);
      #80,#77: Inc(Selection);
    end;
    If Ch = #9 then inc(Selection);
    if Selection = 0 then Selection := 10;
    if Selection = 11 then Selection := 1;
    if lastselection <> selection
    then begin
      ActionBox (Selection=1,25,8,11);
      ActionBox (Selection=2,25,9,12);
      ActionBox (Selection=3,25,11,11);
      RadioBox (Selection-3,At,37,13,4,14,2);
      ActionBox (Selection=8,22,18,7);
      ActionBox (Selection=9,35,18,10);
      ActionBox (Selection=10,51,18,8);
      Case Selection of
        1:  StatusLine (' F1 Help  Type last name of student, 15 letters maximum');
        2:  StatusLine (' F1 Help  Type first name of student, 15 letters maximum');
        3:  StatusLine (' F1 Help  Type student ID number, 8 digits maximum');
        4:  StatusLine (' F1 Help  Press space bar to make student a freshman');
        5:  StatusLine (' F1 Help  Press space bar to make student a sophomore');
        6:  StatusLine (' F1 Help  Press space bar to make student a junior');
        7:  StatusLine (' F1 Help  Press space bar to make student a senior');
        8:  StatusLine (' F1 Help  Add student to school');
        9:  StatusLine (' F1 Help  Leave with adding student to school');
        10: StatusLine (' F1 Help  Help on adding students');
      end;
    end;
    lastselection := selection;
    if (ch in [#32,#13]) or (MoveDown)
    then begin
      MoveDown := FALSE;
      case selection of
           1: begin
                SetCursor(1);
                ReadString2 (S.LastName,38,8,16,ExitCode);
                If exitcode = 0 then MoveDown := True;
                SetCursor(0);
              end;
           2: begin
                SetCursor(1);
                ReadString2 (S.FirstName,38,9,16,ExitCode);
                If exitcode = 0 then MoveDown := True;
                SetCursor(0);
              end;
           3: begin
                SetCursor(1);
                ReadString3 (IdNum,38,11,9,ExitCode);
                Val (IDNum,S.Number,NumberErrorCode);
                If exitcode = 0 then inc(selection);
                SetCursor(0);
              end;
           4:  begin
                 At := 1;
                 S.Class := 1;
               end;
           5:  begin
                 At := 2;
                 S.Class := 2;
               end;
           6:  begin
                 At := 3;
                 S.Class := 3;
               end;
           7:  begin
                 At := 4;
                 S.Class := 4;
               end;
           8:  Ok     := TRUE;
           9:  Cancel := TRUE;
           10: Help   := TRUE
         end;
         lastselection := 0;
    end;
  If MoveDown then Inc(Selection);
  If Help or (ch2 = #59) then begin
       Help := False;
       HelpSystem (2);
  end;
  if Ok and ((S.LastName = '') or ((S.FirstName = '') or (S.Number = 0)))
  then begin
    DisplayMessage ('The information for this student is not completely filled out. ');
    Ok := FALSE;
  end;
  Until (Ch = #27) or (Ok or Cancel);
  drawscreen (screen);
  dispose (screen);
  Case at of
    1: ClassFile := GlobalFiles.Freshman;
    2: ClassFile := GlobalFiles.Sophomore;
    3: ClassFile := GlobalFiles.Junior;
    4: ClassFile := GlobalFiles.Senior;
  end;
  If not (FileExists (ClassFile))
  then CreateClassFile (ClassFile);
  assign (f,classfile);
  reset(f);
  seek(f,filesize(f));
  Stud.Class := At;
  Stud.Number := S.Number;
  Stud.FirstName := S.FirstName;
  Stud.LastName := S.LastName;
  Stud.Hours := 0;
  write (f,Stud);
  close(f);
end;

procedure ConfigLoad;
var f: text;
    Crappo: string;
begin
  assign (f,configfilename);
  reset (f);
  readln (f, GlobalFiles.ProgramDir);
  readln (f, GlobalFiles.BackupDir);
  readln (f, GlobalFiles.HelpDir);
  readln (f, GlobalFiles.ClassDir);
  readln (f, GlobalFiles.Index);
  readln (f, GlobalFiles.Freshman);
  readln (f, GlobalFiles.Sophomore);
  readln (f, GlobalFiles.Junior);
  readln (f, GlobalFiles.Senior);
  readln (f, Crappo);
  AutosaveOn := Crappo = 'AUTOSAVE IS ON';  { <----- Slick! }
  readln (f, AutosaveTicks);
  readln (f, AutosaveTime);
  close (f);
end;


procedure ConfigSave;
var f: text;
    TempString: String;
begin
  assign (f,configfilename);
  rewrite (f);
  writeln (GlobalFiles.ProgramDir);
  readln (f, GlobalFiles.BackupDir);
  readln (f, GlobalFiles.HelpDir);
  readln (f, GlobalFiles.ClassDir);
  readln (f, GlobalFiles.Index);
  readln (f, GlobalFiles.Freshman);
  readln (f, GlobalFiles.Sophomore);
  readln (f, GlobalFiles.Junior);
  readln (f, GlobalFiles.Senior);
  readln (f, TempString);
  AutosaveOn := TempString = 'AUTOSAVE IS ON';  { <----- Slick! }
  readln (f, AutosaveTicks);
  readln (f, AutosaveTime);
  close (f);
end;


var Selection,MDS: byte;
    C: StudentArray;
    Rec: StudentRecordNP;
    f1: file of studentRecordNP;

begin
  GetDir (0,GlobalFiles.CurrentDir);
  GlobalFiles.BackupDir  := 'C:\SERVICE\BACKUP';
  GlobalFiles.ClassDir   := 'C:\SERVICE\CLASSDAT';
  GlobalFiles.HelpDir    := 'C:\SERVICE\HELP';
  GlobalFiles.CurrentDir := 'C:\SERVICE';
  GlobalFiles.Freshman   := 'FRESHMAN.DAT';
  GlobalFiles.Sophomore  := 'SOPHMR.DAT';
  GlobalFiles.Junior     := 'JUNIOR.DAT';
  GlobalFiles.Senior     := 'SENIOR.DAT';
  GlobalFiles.Index      := 'SCHOOL.IND';
  AutosaveOn := TRUE;
  AutosaveTime := 5;
  AutosaveTicks := 18*20*5;
  SetUpWindows;
  SetCursor(0);
  FillScreen ('',15,0);
  WriteString (TopMenuText,1,1,0,7);
  StatusLine ('');
  Selection := 1;
  New(C[1]);
  repeat
  MainMenuTop (Selection,MDS);
  If (Selection = 1) and (MDS = 1) then LoadClass;
  If (Selection = 2) and (MDS = 1) then Add_Student(C[1]^);
  If (Selection = 4) and (MDS = 2) then GetAutoSave;
  If (Selection = 4) and (MDS = 3) then ChangeDirectories;
  If (Selection = 6) and (MDS = 5) then IntroCredits;
  until (Selection = 1) and (MDS = 6);
  clrscr;
  setcursor(1);
end.