program Search;

uses dos,crt,Input;

{$I-}

type FileRecord = Record
       Attr: Word;
       Day,
       Month,
       Year,
       Hour,
       Minute: Word;
       Size: LongInt;
       Name: String[12];
     end;
     String12 = String[12];

var showdirs:boolean;

function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  if Length(s) > 2 then S := S[Length(s)-1] + S[Length(s)];
  LeadingZero := s;
end;


function MakeLongTimeDateString (Year,Month,Day,Hour,Minute: Word): String;
Const MonthString : Array[1..12] of String[20] = ('January','Februray',
  'March','April','May','June','July','August','September','October',
  'November','December');
var NumString,Temp: String;
begin
  Str(Year,NumString);
  Temp := MonthString[Month]+' '+LeadingZero(Day)+', '+NumString
   +'  ';
  If Hour < 13
  Then Temp := Temp + Leadingzero(Hour)+':'+Leadingzero(Minute)+'am'
  Else Temp := Temp + Leadingzero(Hour-12)+':'+Leadingzero(Minute)+'pm';


  MakeLongTimeDateString := Temp;
end;


function MakeTimeDateString (Year,Month,Day,Hour,Minute: Word): String;
begin
  MakeTimeDateString := LeadingZero(Month)+'/'+
                        LeadingZero(Day)+'/'+
                        LeadingZero(Year)+'   '+
                        LeadingZero(Hour)+':'+
                        LeadingZero(Minute);
end;

function FileExists(Filename: Pathstr): Boolean;
var F: file of byte;
begin
  assign (F,Filename);
  reset (F);
  If IOresult = 0
  then begin
    FileExists := TRUE;
    Close (F);
  end
  else FileExists := FALSE;
end;

procedure GetFileInfo(Filename: PathStr; var Info: FileRecord);
var F: File of Byte;
    Path,Name,Ext: String;
    Time: Longint;
    Dt: Datetime;
begin
  assign (F,Filename);
  reset (F);
  If IOresult = 0
  then begin
    Info.Size := FileSize(F);
    GetFTime (F,Time);
    UnpackTime (Time,DT);
    Info.Year   := DT.Year;
    Info.Month  := DT.Month;
    Info.Day    := DT.Day;
    Info.Hour   := DT.Hour;
    Info.Minute := DT.Min;
    GetFAttr (F,Info.Attr);
    FSplit(Filename,Path,Name,Ext);
    Info.Name := Name+Ext;
    Close (F);
  end
end;

procedure SearchForAFile (filename: string12; Drive: char);

procedure FileSearch (Path: Pathstr;Filename: string12);
var S: SearchRec;
begin
  if Showdirs then Writeln ('Searching ',Path);
  FindFirst('*.*',AnyFile,S);
  If (S.Name = Filename) and (S.Attr <> Directory)
    then writeln ('Found at ',Path);
  If (S.Attr = Directory) and not((S.Name = '.') or (S.Name = '..'))
  then begin
    ChDir (Path+'\'+S.Name);
    Filesearch(Path+'\'+S.Name,Filename);
  end;
  Findnext(S);
  While DosError = 0 do
  begin
    If (S.Name = Filename) and (S.Attr <> Directory)
      then writeln ('Found at ',Path);
    If (S.Attr = Directory) and not((S.Name = '.') or (S.Name = '..'))
      then begin
        ChDir (Path+'\'+S.Name);
        Filesearch(Path+'\'+S.Name,Filename);
      end;
    Findnext(S);
  end;
  DosError := 0;
end;


var Dir: String;
begin
  GetDir (0,Dir);
  ChDir (Drive+':\');
  FileSearch(Drive+':',Filename);
  ChDir (Dir);
end;


var
  Filename: string12;
  Param,Command: string;
  ch,ch2: char;
  i,num: byte;

begin
  write ('Enter a filename to search: ');
  readln (filename);
  write ('Enter drive to be searched: ');
  repeat
    getkey (ch,ch2);
  until upcase(ch) in ['A'..'Z'];
  showdirs := TRUE;
  for i := 1 to length(Filename) do Filename[i] := Upcase(Filename[i]);
  writeln ('Searching for ',Filename);
  SearchForAFile (Filename,ch);
  writeln;
  writeln ('Press return to continue');
  readln;
  clearbuffer;
end.
