program Convert;

uses crt,dos;

type

  string40 = string[40];
  string15 = string[15];

  ServiceRecord = Record            { Record for each service preformed
                                      mem = 48 bytes }
    DateMonth,                      {  Month where Jan=1 Feb=2 ... Dec=12 }
    DateYear:       Byte;           { Same mothod as YearOfGrad }
    Descript:       String40;       { Description of Service }
    Time:           Real;           { Amount of time done for service }
  end;

  ServiceArrayPtr  = Array[1..25] of ^ServiceRecord;
  ServiceArray = Array[1..25] of ServiceRecord;

  StudentRecord = Record            { Each Student is stored in this record }
    Number:  LongInt;
    LastName:       string15;       { Last name of stuent }
    FirstName:      string15;
    Hours:          Real;
    Class:          Byte;
    Service:        ServiceArrayPtr;
  end;


  StudentRecordNP = Record            { Each Student is stored in this record }
    Number:  LongInt;
    LastName:       string15;       { Last name of stuent }
    FirstName:      string15;
    Hours:          Real;
    Class:          Byte;
    Service:        ServiceArray;
  end;

procedure InitStudentRecord(var S: StudentRecordNP);
var i: byte;
begin
  S.Number := 0;
  S.LastName := '';
  S.FirstName := '';
  S.Hours := 0;
  S.Class := 0;
  for i := 1 to 25 do begin
    S.Service[i].Descript := '';
    S.Service[i].Time := 0;
    S.Service[i].DateMonth := 0;
    S.Service[i].DateYear := 0;
  end;
end;

var f1,f2,f3,f4: file of studentrecordNP;
    f: text;
    s: string;
    REC: StudentRecordNP;
    id: longint;          i,class: byte;
    first,last: string15;
    ErrorCode: integer;
    Hours: real;
    count: word;
begin
  count := 0;
  assign(F,'Students.Txt');
  assign(F1,'Freshman.Dat');
  assign(F2,'Sophmr.Dat');
  assign(F3,'Junior.Dat');
  assign(F4,'Senior.Dat');
  reset (f);
  rewrite (f1);
  rewrite (f2);
  rewrite (f3);
  rewrite (f4);
  clrscr;
  Write ('Sorting Files');
  while not(eof(f)) and not(keypressed)
  do begin
    write ('.');
    readln (f,s);
    inc(count);
    last := copy(s,1,pos(#009,s)-1);
    delete (s,1,pos(#009,s));
    first := copy(s,1,pos(#009,s)-1);
    delete (s,1,pos(#009,s));
    delete (s,1,pos(#009,s));
    val (copy(s,1,pos(#009,s)-1),Hours,Errorcode);
    delete (s,1,pos(#009,s));
    val (copy(s,1,pos(#009,s)-1),ID,Errorcode);
    val (copy(s,1,2),Class,Errorcode);
    Class := 99-Class;
    InitStudentRecord(Rec);
    Rec.Number :=     ID;
    Rec.LastName :=   Last;
    Rec.FirstName :=  First;
    Rec.Hours :=      Hours;
    case class of
      1: write (f1,rec);
      2: write (f2,rec);
      3: write (f3,rec);
      4: write (f4,rec);
    end;
  end;
  writeln ('Done!');
  write (Count,' Students Sorted');
  close(f);
  close(f1);
  close(f2);
  close(f3);
  close(f4);
  readln;
end.