{ Contains routines and data to directly access video memory
  Written by Tim J. Duncan
  Compuserve 72603,3616
}
unit Video;

{}Interface{}

uses
  Crt;  {  Borland unit  }

const
  MaxTextRows = 50;
  MaxTextColumns = 80;

type
  {  Define record to access single location in video memory  }
  TVideoMemRecord =
    record
    Character : byte;
    Attribute : byte;
    end;  {  of TVideoMemRecord  }

  {  Type to hold entire contents of video memory  }
  PVideoMem = ^TVideoMem;
  TVideoMem = array [0..MaxTextRows] of array [0..MaxTextColumns] of TVideoMemRecord;

var
  {  Holds entire contents of video memory  }
  VideoMemoryCopy : PVideoMem;

{  Frees the memory allocated to make a copy of video memory  }
procedure FreeVideoMemoryCopy;
{  Saves a copy of video memory  }
procedure SaveDOSScreen;
{  Updates video memory with the previously saved copy  }
procedure UpdateDOSScreen;
{  Updates the copy of video memory with the current contents of video memory  }
procedure UpdateVideoMemoryCopy;

{}Implementation{}

var
  {  Holds the amount of memory allocated to make a copy of video memory  }
  VideoMemorySize : word;
  {  Holds where video memory begins  }
  VideoMemoryLocation : pointer;

{  Determines the location of video memory for color or monochrome cards  }
procedure GetVideoMemoryLocation;

  var
    {  Accesses info from video BIOS  }
    {  From PC System Programming, pg 560  }
    CRTC_Port : word absolute $0040:0063;

  begin
  if CRTC_Port = $3B4
    then begin
    {  Monochrome card exists  }
    VideoMemoryLocation := Ptr (SegB000, $0);
    end  {  then  }
    else begin
    {  Color card exists  }
    VideoMemoryLocation := Ptr (SegB800, $0);
    end;  {  else }
  end;  {  of procedure GetMemoryLocation  }

{  Frees the memory allocated to copy video memory  }
procedure FreeVideoMemoryCopy;
  begin
  FreeMem (VideoMemoryCopy, VideoMemorySize);
  end;  {  procedure FreeVideoMemoryCopy  }

{  Saves a copy of video memory  }
procedure SaveDOSScreen;
  begin
  GetVideoMemoryLocation;
  VideoMemorySize := (lo (WindMax) + 1) * (hi (WindMax) + 1) * 2;
  GetMem (VideoMemoryCopy, VideoMemorySize);
  UpdateVideoMemoryCopy;
  end;  {  of procedure SaveDOSScreen  }

{  Updates video memory with the previously saved copy  }
procedure UpdateDOSScreen;
  begin
  move (VideoMemoryCopy^, VideoMemoryLocation^, VideoMemorySize);
  end;  {  of procedure RestoreDOSScreen  }

{  Updates the copy of video memory with the current contents of video memory  }
procedure UpdateVideoMemoryCopy;
  begin
  move (VideoMemoryLocation^, VideoMemoryCopy^, VideoMemorySize);
  end;  {  of procedure UpdateVideoMemoryCopy  }

begin
end.  {  unit  }
