{************************************************}
{                                                }
{   ObjectWindows Paint demo                     }
{   Copyright (c) 1992 by Borland International  }
{   Function StoreBitmap adapted to create       }
{   Function hBitmapToDIB                        }
{                                                }
{   submitted by Ravi Nielsen 73200,601          }
{                                                }
{************************************************}

{
hBitmapToDIB creates a handle to a DIB in memory from a hBitmap.
This handle can then be passed to the clipboard.
Hope everything is ok--no guarantees, but it seems to work!
}

unit dib;

Interface

uses Objects,Omemory,OWindows,WinTypes, WinProcs;
{, WinDos, Strings, Win31,shellapi,pwMsgs,toolhelp,pwswdefs;}
Implementation

Function hBitmapToDIB(DC:hdc;hBM:hBitmap):THandle;
{Adapted from StoreBitmap in bp\examples\win\paint\bitmaps.pas}
  var
    BM:   TBitmap;		{ Bitmap information }
    BMInfo:  PBitmapInfo;	{ DIB bitmap information }

    HMem: THandle;		{ Handle to memory for bitmap }
    Buf:  Pointer;		{ Memory for Info plus bitmap }
    BitsBuf:  Pointer;		{ offset pointer to bits part of buf }

    ColorSize, DataSize: Longint; { Size needed to store Color/Data }
    BitCount: Word;		{ Number of bits per pixel }
    BMInfoSize: word;		{ Header plus Palette }

  { Takes the size in bits and returns the (aligned) size in bytes.
    Bitmap data format requires word alignment.
  }
  function bmAlignDouble(Size: Longint): Longint;
  begin
    bmAlignDouble := (Size + 31) div 32 * 4;
  end;

begin
   hBitmapToDIB:= 0;
   { Get the information about the Bitmap }
   if GetObject(HBM, SizeOf(TBitmap), @BM) = 0 then Exit;

   BitCount := bm.bmPlanes * bm.bmBitsPixel;
   if (BitCount <> 24) then
     ColorSize := SizeOf(TRGBQuad) * (1 shl BitCount)
   else
     ColorSize := 0;
   DataSize := bmAlignDouble(bm.bmWidth * BitCount) * bm.bmHeight;

   { Allocate memory for the bitmap info structure }
   BMInfoSize:=SizeOf(TBitmapInfoHeader) + ColorSize;
   GetMem(BMInfo, BMInfoSize);
   if BMInfo <> nil then
   begin
     { Fill in the Bitmap info header }
     with BMInfo^.bmiHeader do
     begin
       biSize := SizeOf(TBitmapInfoHeader);
       biWidth := bm.bmWidth;
       biHeight := bm.bmHeight;
       biPlanes := 1;
       biBitCount := BitCount;
       biCompression := 0;
       biSizeImage := DataSize;
       biXPelsPerMeter := 0;
       biYPelsPerMeter := 0;
       biClrUsed := 0;
       biClrImportant := 0;
     end;

     {Call GetDIBits once to fill the Color info in BMInfo}
{$r-}
       GetDIBits(DC, hbm, 0, bm.bmheight, Nil, BMInfo^, dib_RGB_Colors);
{$r+}


     { Create a DIB memory block by first moving the BitmapInfo structure into memory, then
        shifting the pointer over before calling GetDIBits.
        First get enough memory for the the InfoStructure (header+palette) plus the bits }
     HMem := GlobalAlloc(gmem_Fixed, BMInfoSize+DataSize);
     if HMem <> 0 then
     begin
       Buf := GlobalLock(HMem);
       move(BMInfo^, Buf^, BMInfoSize);
       longint(BitsBuf):=longint(Buf)+BMInfoSize;

       { Get the bitmap bits in device independent format }
{$r-}
       if GetDIBits(DC, hbm, 0, bm.bmheight, BitsBuf, BMInfo^, dib_RGB_Colors) <> 0 then
{$r+}
       begin
         { Release lock }
          GlobalUnlock(HMem);
          hBitmapToDIB:=hMem;
        {calling proc has line: hDIB:=hBitmapToDib;  and calls
        SetClipboardData(cf_DIB, hDIB) after opening and emptying clipboard}
       end
      else
       begin
        { Release lock and free memory }
        GlobalUnlock(HMem);
        GlobalFree(HMem);
       end;
     end;
     FreeMem(BMInfo, BMInfoSize);
   end;
end;

procedure Filltheclipboard(hw:hWnd;hBM:HBitmap);
 var
    DC : hDC;
    hDIB:THandle;
begin
  BEGIN
    IF NOT OpenClipboard(hW) THEN
      BEGIN
        {uses strmsgs unit
        GiveMsg(hW,MT_ClipUnavailable,MC_ClipUnavailable,mb_OK or mb_iconInformation,
                   mb_iconInformation,FunctionalMsg);
        }
        Exit;
      END;
    IF NOT EmptyClipboard THEN
        begin
        {uses strmsgs unit
          GiveMsg(hW,MT_ClipUnavailable,MC_ClipUnavailable,mb_OK or mb_iconExclamation,mb_iconExclamation,SeriousMsg);
          }
          exit;
        end;
    DC := GetDC(hW);
    hDIB:=hBitmapToDIB(DC,hBM);
    if hDIB<>0 then SetClipboardData(cf_DIB, hDIB);
    ReleaseDC(hW, DC);
    CloseClipboard;
  end;
end;

end.