unit Math2;

interface

uses winprocs,math1;


FUNCTION EVEN(TEST,YES,NO:REAL):REAL;
FUNCTION POWER1(Y,X,DEFAULT:REAL):REAL;
FUNCTION QUAD(Y,X:REAL):INTEGER;
FUNCTION ARCSIN(S:REAL):REAL;
FUNCTION ARCTAN1(NUM,DENOM:REAL):REAL;
FUNCTION VLENGTH(V1,V2,V3,E1,E2,E3:REAL):REAL;
FUNCTION LOC(B,C,A:REAL;MODE:INTEGER):REAL;
FUNCTION LOS(A,AANGLE,B,DEFAULT:REAL;MODE:INTEGER):REAL;
PROCEDURE COMPLEXCONVERT(A1,A2:REAL;MODE:INTEGER;VAR O);
PROCEDURE SPHERICAL_XYZ(S1,S2,S3:REAL;MODE:INTEGER;VAR SA);
PROCEDURE XYZROTTRANS(X,Y,Z,X1,Y1,Z1,X2,Y2,Z2,T1,T2,T3,XM,YM,ZM:REAL;MODE:INTEGER;VAR R);
PROCEDURE BAIRSTOW(VAR A,B;EPSILON:REAL;IT1,DEGREE:INTEGER);
PROCEDURE MULTIPLYCR(X,Y,X1,Y1:REAL;VAR Z);
PROCEDURE DEVIDECR(N1,N2,D1,D2:REAL;VAR R);
PROCEDURE ADDSUBCP(A1,A2,B1,B2:REAL;MODE:INTEGER;VAR R);
PROCEDURE POWERCR_CP(A1,A2,B1,B2:REAL;MODE:INTEGER;VAR R);
PROCEDURE RAYS_XYZ(X,Y,Z,X1,Y1,Z1,X2,Y2,Z2,XM1,YM1,ZM1:REAL;COUNT:INTEGER;VAR RIN,ROUT);

implementation

FUNCTION EVEN(TEST,YES,NO:REAL):REAL;
BEGIN
IF TEST/2=TRUNC(TEST/2) THEN
BEGIN
EVEN:=YES;
END
ELSE
BEGIN
EVEN:=NO;
END;
END;

FUNCTION POWER1(Y,X,DEFAULT:REAL):REAL;
VAR
Y1:INTEGER;
BEGIN
IF Y<=0 THEN
BEGIN
Y1:=-1;
IF Y=0 THEN
BEGIN
POWER1:=0;
END
ELSE
BEGIN
IF TRUNC(X)=X THEN
BEGIN
POWER1:=(Y1+EVEN(X,2,0))*(EXP(X*LN(ABS(Y))));
END
ELSE
BEGIN
POWER1:=DEFAULT;
END;
END;
END
ELSE
BEGIN
POWER1:=EXP(X*LN(Y));
END;
END;

FUNCTION QUAD(Y,X:REAL):INTEGER;
BEGIN
{quad is used with arctan1.  assigns values from 0 to 8 as you rotate in x-y plane
around z axis.  numbers represent axis or quadrants}
IF (Y=0)AND(X=0) THEN
BEGIN
QUAD:=0;
END
ELSE
BEGIN
IF (Y=0)OR(X=0) THEN
BEGIN
IF Y=0 THEN
BEGIN
IF X<0 THEN
BEGIN
QUAD:=5;
END
ELSE
BEGIN
QUAD:=1;
END;
END
ELSE
BEGIN
IF Y<0 THEN
BEGIN
QUAD:=7;
END
ELSE
BEGIN
QUAD:=3;
END;
END;
END
ELSE
BEGIN
IF Y>0 THEN
BEGIN
IF X>0 THEN
BEGIN
QUAD:=2;
END
ELSE
BEGIN
QUAD:=4;
END;
END
ELSE
BEGIN
IF X>0 THEN
BEGIN
QUAD:=8;
END
ELSE
BEGIN
QUAD:=6;
END;
END;
END;
END;
END;

FUNCTION ARCSIN(S:REAL):REAL;
VAR
C,F:REAL;
BEGIN
IF ABS(S)>1 THEN
BEGIN
ARCSIN:=0;
END
ELSE
BEGIN
IF ABS(S)=1 THEN
BEGIN
ARCSIN:=(S/ABS(S))*PI/2;
END
ELSE
BEGIN
C:=SQRT(1-SQR(S));
F:=ARCTAN(S/ABS(C));
ARCSIN:=F;
END;
END;
END;

FUNCTION ARCTAN1(NUM,DENOM:REAL):REAL;
VAR
Q:INTEGER;
BEGIN
{with num as numerator and denom as denominator, arctan1 gives values from 0 to 2*pi
instead of -pi/2 to pi/2, good for use with rotating object}
Q:=QUAD(NUM,DENOM);
CASE Q OF
0:ARCTAN1:=0;
1:ARCTAN1:=0;
2:ARCTAN1:=ARCTAN(NUM/DENOM);
3:ARCTAN1:=PI/2;
4:ARCTAN1:=ARCTAN(NUM/DENOM)+PI;
5:ARCTAN1:=PI;
6:ARCTAN1:=ARCTAN(NUM/DENOM)+PI;
7:ARCTAN1:=3*PI/2;
8:ARCTAN1:=ARCTAN(NUM/DENOM)+2*PI;
ELSE
ARCTAN1:=0;
END;
END;

FUNCTION VLENGTH(V1,V2,V3,E1,E2,E3:REAL):REAL;
BEGIN
{gives vector length for head of vector v1v2v3 to tail e1e2e3}
VLENGTH:=SQRT(((v1-e1)*(V1-E1))+((v2-e2)*(V2-E2))+((v3-e3)*(V3-E3)));
END;

FUNCTION LOC(B,C,A:REAL;MODE:INTEGER):REAL;
BEGIN
{law if cosines, b and c are sides, a can be angle or side, for mode=1, a angle, result is length
of third side opposite a,  for mode<>1 then a,b,c, sides and angle opposite a is solved for}
IF MODE=1 THEN
BEGIN
IF (B=0)OR(C=0) THEN
BEGIN
LOC:=SQRT(SQR(B)+SQR(C));
END
ELSE
BEGIN
LOC:=SQRT(SQR(B)+SQR(C)-(2*B*C*COS(A)));
END;
END
ELSE
BEGIN
IF (B=0)OR(C=0) THEN
BEGIN
LOC:=0;
END
ELSE
BEGIN
LOC:=ARCCOS((SQR(B)+SQR(C)-SQR(A))/(2*B*C));
END;
END;
END;

FUNCTION LOS(A,AANGLE,B,DEFAULT:REAL;MODE:INTEGER):REAL;
BEGIN
{law of sines, aangle opposite a side, mode 1,a side, b angle, solves for side opposite b angle
mode<>1, a,b sides solves for angle opposite to b} 
IF MODE=1 THEN
BEGIN
IF (A=0)OR(AANGLE=0) THEN
BEGIN
LOS:=DEFAULT;
END
ELSE
BEGIN
LOS:=(A*SIN(B))/(SIN(AANGLE));
END;
END
ELSE
BEGIN
IF (A=0)OR(AANGLE=0) THEN
BEGIN
LOS:=DEFAULT;
END
ELSE
BEGIN
LOS:=ARCSIN((B*SIN(AANGLE))/A);
END;
END;
END;

PROCEDURE COMPLEXCONVERT(A1,A2:REAL;MODE:INTEGER;VAR O);
TYPE
O1=ARRAY[1..2] OF REAL;
BEGIN
{mode 1:a1 magnitude a2 angle, converts to rectangular coordinates and places them in o:array[1..2] of real
mode<>1:a1 real a2 imaginary converts to polar and places magnitude in o[1] and angle in o[2]}
IF MODE=1 THEN
BEGIN
O1(O)[1]:=A1*COS(A2);
O1(O)[2]:=A1*SIN(A2);
END
ELSE
BEGIN
O1(O)[1]:=SQRT(SQR(A1)+SQR(A2));
O1(O)[2]:=ARCTAN1(A2,A1);
END;
END;


PROCEDURE SPHERICAL_XYZ(S1,S2,S3:REAL;MODE:INTEGER;VAR SA);
TYPE
SXYZ=ARRAY[1..3] OF REAL;
VAR
S:REAL;
BEGIN
{in mode 1:s1=ro,s2=theta,s3=phi converts to xyz and places them in sa:array[1..3] of real
{in mode<>1 s1=x,s2=y,s3:=z converts to ro,theta,phi and places them in sa in that order}
IF MODE=1 THEN
BEGIN
SXYZ(SA)[1]:=S1*COS(S2)*SIN(S3);
SXYZ(SA)[2]:=S1*SIN(S2)*SIN(S3);
SXYZ(SA)[3]:=S1*COS(S3);
END
ELSE
BEGIN
S:=SQRT(SQR(S1)+SQR(S2)+SQR(S3));
SXYZ(SA)[1]:=S;
SXYZ(SA)[2]:=ARCTAN1(S2,S1);
SXYZ(SA)[3]:=ARCCOS(S3/S);
END;
END;

PROCEDURE XYZROTTRANS(X,Y,Z,X1,Y1,Z1,X2,Y2,Z2,T1,T2,T3,XM,YM,ZM:REAL;MODE:INTEGER;VAR R);
LABEL 3,4,5;
TYPE
R1=ARRAY[1..3] OF REAL;
VAR
U:ARRAY[1..3] OF REAL;
U1:ARRAY[1..3] OF REAL;
U2:ARRAY[1..3] OF REAL;
U3:ARRAY[1..26] OF REAL;
U4:ARRAY[1..10] OF REAL;
H10:ARRAY[1..3,1..4] OF REAL;
M,AXIS:INTEGER;
A,B,LEN,XX,XY,XZ,ZX,ZY,ZZ,YX,YY,YZ,XN,XN1,XN2,XN3,YN,YN1,YN2,YN3,
ZN,ZN1,ZN2,ZN3,XYZN,XYZN1,XYZN2,XYZN3:REAL;
BEGIN
{takes a point x,y,z and rotates the coordinate system its in and gives the new coordinates
for x,y,z in the old coordinate system's perpective.  x1,y1,z1 is new z axis vector, x2,y2,z2 is
new x axis vector, t1,t2,t3 is new coordinates for old systems origin, xm,ym,zm are amplitude
adjusts for x,y,z.  Mode 1 then new point is loaded into r:array[1..3] of real in rectangular
coordinates else r is loaded with spherical coordinates with r[1]=ro,r[2]=theta,r[3]=phi}
IF (X=0)AND(Y=0)AND(Z=0) THEN
BEGIN
U[1]:=X*XM;
U[2]:=Y*YM;
U[3]:=Z*ZM;
GOTO 3;
END;
LEN:=VLENGTH(X,Y,Z,0,0,0);
CROSSPRODUCT(X1,Y1,Z1,X2,Y2,Z2,0,0,0,U3);
YX:=U3[5];
YY:=U3[6];
YZ:=U3[7];
VUNIT(X1,Y1,Z1,0,0,0,TRUE,U4);
ZX:=U4[1];
ZY:=U4[2];
ZZ:=U4[3];
VUNIT(X2,Y2,Z2,0,0,0,TRUE,U4);
XX:=U4[1];
XY:=U4[2];
XZ:=U4[3];

H10[1,1]:=XX;
H10[1,2]:=XY;
H10[1,3]:=XZ;
H10[1,4]:=X;
H10[2,1]:=YX;
H10[2,2]:=YY;
H10[2,3]:=YZ;
H10[2,4]:=Y;
H10[3,1]:=ZX;
H10[3,2]:=ZY;
H10[3,3]:=ZZ;
H10[3,4]:=Z;
XN1:=H10[1,4]*((H10[2,2]*H10[3,3])-(H10[2,3]*H10[3,2]));
XN2:=-H10[1,2]*((H10[2,4]*H10[3,3])-(H10[2,3]*H10[3,4]));
XN3:=H10[1,3]*((H10[2,4]*H10[3,2])-(H10[2,2]*H10[3,4]));
XN:=XN1+XN2+XN3;
YN1:=H10[1,1]*((H10[2,4]*H10[3,3])-(H10[2,3]*H10[3,4]));
YN2:=-H10[1,4]*((H10[2,1]*H10[3,3])-(H10[2,3]*H10[3,1]));
YN3:=H10[1,3]*((H10[2,1]*H10[3,4])-(H10[2,4]*H10[3,1]));
YN:=YN1+YN2+YN3;
ZN1:=H10[1,1]*((H10[2,2]*H10[3,4])-(H10[2,4]*H10[3,2]));
ZN2:=-H10[1,2]*((H10[2,1]*H10[3,4])-(H10[2,4]*H10[3,1]));
ZN3:=H10[1,4]*((H10[2,1]*H10[3,2])-(H10[2,2]*H10[3,1]));
ZN:=ZN1+ZN2+ZN3;
XYZN1:=H10[1,1]*((H10[2,2]*H10[3,3])-(H10[2,3]*H10[3,2]));
XYZN2:=-H10[1,2]*((H10[2,1]*H10[3,3])-(H10[2,3]*H10[3,1]));
XYZN3:=H10[1,3]*((H10[2,1]*H10[3,2])-(H10[2,2]*H10[3,1]));
XYZN:=XYZN1+XYZN2+XYZN3;
IF ((ABS(XYZN))<0.000000001) THEN
BEGIN
U[1]:=X*XM;
U[2]:=Y*YM;
U[3]:=Z*ZM;
END
ELSE
BEGIN
U[1]:=(XN/XYZN)*XM;
U[2]:=(YN/XYZN)*YM;
U[3]:=(ZN/XYZN)*ZM;
END;
3:
IF MODE=1 THEN
BEGIN
U1[1]:=U[1]+T1;
U1[2]:=U[2]+T2;
U1[3]:=U[3]+T3;
END
ELSE
BEGIN
U1[1]:=U[1]+T1;
U1[2]:=U[2]+T2;
U1[3]:=U[3]+T3;
SPHERICAL_XYZ(U1[1],U1[2],U1[3],2,U2);
END;
IF MODE=1 THEN
BEGIN
R1(R)[1]:=U1[1];
R1(R)[2]:=U1[2];
R1(R)[3]:=U1[3];
END
ELSE
BEGIN
R1(R)[1]:=U2[1];
R1(R)[2]:=U2[2];
R1(R)[3]:=U2[3];
END;
END;


PROCEDURE BAIRSTOW(VAR A,B;EPSILON:REAL;IT1,DEGREE:INTEGER);
LABEL 1,2,3,4,5,6,8;
TYPE
A1=ARRAY[1..200] OF REAL;
B1=ARRAY[1..200,1..2] OF REAL;
VAR
U,U1,V,V1,P,Q,W,R,DENOM,Z,Z1,SUM,RAD:REAL;
F,F1,F2,C1,C2,IT,N:INTEGER;
C:ARRAY[1..200] OF REAL;
D:ARRAY[1..200] OF REAL;
E:ARRAY[1..200] OF REAL;
BEGIN
{bairstow takes a polynomial of to degree 200 and solves for the roots.  if polynomial is
ax^2 + bx + c=0 then first it is normalized to x^2 + (b/a)x + (c/z)=0, then the first
element in a , a[1]=(b/a)  and a[2]=(c/a).  The highest degree coefficient for x^2 is always
understood to be one.  epsilon=as low a number you want for accuracy, it1=number of iterations
before routine calls it quits (for example if the root won't converge), and in this example,
degree is 2.  Bairstow will load B with real and imaginary root values.  b[x,1]=real,b[x,2]=imaginary}
FOR F:=1 TO DEGREE DO
BEGIN
E[F]:=A1(A)[F];
END;
C1:=1;
U1:=0;
V1:=0;
N:=DEGREE;
1:
IF N<1 THEN
BEGIN
FOR F:=1 TO 200 DO
BEGIN
FOR F1:=1 TO 2 DO
BEGIN
B1(B)[F,F1]:=0;
END;
END;
END
ELSE
BEGIN
IF N=1 THEN
BEGIN
P:=-E[1];
Q:=0;
B1(B)[C1,1]:=P;
B1(B)[C1,2]:=Q;
C1:=C1+1;
END
ELSE
BEGIN
IF N=2 THEN
BEGIN
U:=E[1];
V:=E[2];
4:
P:=-U/2;
RAD:=(SQR(U))-(4*V);
IF RAD<0 THEN
BEGIN
RAD:=-RAD;
Q:=(SQRT(RAD))/2;
B1(B)[C1,1]:=P;
B1(B)[C1,2]:=Q;
N:=N-1;
C1:=C1+1;
Q:=-Q;
2:
B1(B)[C1,1]:=P;
B1(B)[C1,2]:=Q;
N:=N-1;
C1:=C1+1;
IF N<=0 THEN GOTO 8;
FOR F2:=1 TO N DO
BEGIN
E[F2]:=C[F2];
END;
GOTO 1;
END
ELSE
BEGIN
Q:=(SQRT(RAD))/2;
W:=P;
R:=Q;
P:=P+Q;
Q:=0;
B1(B)[C1,1]:=P;
B1(B)[C1,2]:=Q;
N:=N-1;
C1:=C1+1;
P:=W-R;
GOTO 2;
END;
END
ELSE
BEGIN
U:=U1;
V:=V1;
IT:=1;
5:
C[1]:=E[1]-U;
C[2]:=E[2]-(C[1]*U)-V;
FOR F2:=3 TO N DO
BEGIN
C[F2]:=E[F2]-(C[F2-1]*U)-(C[F2-2]*V);
END;
D[1]:=C[1]-U;
D[2]:=C[2]-(D[1]*U)-V;
C2:=N-1;
FOR F2:=3 TO C2 DO
BEGIN
D[F2]:=C[F2]-(D[F2-1]*U)-(D[F2-2]*V);
END;
IF N=3 THEN GOTO 6;
DENOM:=(D[N-1]*D[N-3])-(SQR(D[N-2]));
IF DENOM=0 THEN GOTO 8;
Z:=(C[N]*D[N-3]-C[N-1]*D[N-2])/DENOM;
GOTO 3;
6:
DENOM:=D[N-1]-(SQR(D[N-2]));
IF DENOM=0 THEN GOTO 8;
Z:=(C[N]-(C[N-1]*D[N-2]))/DENOM;
3:
Z1:=((D[N-1]*C[N-1])-(D[N-2]*C[N]))/DENOM;
U:=U+Z;
V:=V+Z1;
SUM:=ABS(Z)+ABS(Z1);
IF SUM<EPSILON THEN GOTO 4;
IT:=IT+1;
IF IT>IT1 THEN GOTO 8;
GOTO 5;
END;
END;
END;
8:
END;

PROCEDURE MULTIPLYCR(X,Y,X1,Y1:REAL;VAR Z);
TYPE
Z1=ARRAY[1..2] OF REAL;
VAR
A,B:REAL;
Z2:ARRAY[1..2] OF REAL;
Z3:ARRAY[1..2] OF REAL;
BEGIN
{multiplycr takes two rectangular complex numbers x,y and x1,y1 and stores their product
in z:array[1..2] of real;,z[1]=real,a[2]=imaginary}
COMPLEXCONVERT(X,Y,0,Z2);
COMPLEXCONVERT(X1,Y1,0,Z3);
A:=Z2[1]*Z3[1];
B:=Z2[2]+Z3[2];
COMPLEXCONVERT(A,B,1,Z2);
Z1(Z)[1]:=Z2[1];
Z1(Z)[2]:=Z2[2];
END;

PROCEDURE DEVIDECR(N1,N2,D1,D2:REAL;VAR R);
TYPE
R1=ARRAY[1..2] OF REAL;
VAR
A,B:REAL;
R2:ARRAY[1..2] OF REAL;
R3:ARRAY[1..2] OF REAL;
BEGIN
{devidecr takes complex numbers(rect) n1,n2 and d1,d2 and devides n by d storing in r:array[1..2] of real;}
COMPLEXCONVERT(N1,N2,0,R2);
COMPLEXCONVERT(D1,D2,0,R3);
A:=R2[1]/R3[1];
B:=R2[2]-R3[2];
COMPLEXCONVERT(A,B,1,R2);
R1(R)[1]:=R2[1];
R1(R)[2]:=R2[2];
END;

PROCEDURE ADDSUBCP(A1,A2,B1,B2:REAL;MODE:INTEGER;VAR R);
TYPE
R1=ARRAY[1..2] OF REAL;
VAR
A,B:REAL;
R2:ARRAY[1..2] OF REAL;
R3:ARRAY[1..2] OF REAL;
BEGIN
{addsubcp takes complex numbers in polar form and adds them for mode=1 or subtracts b from a and
stores in r:array[1..2] of real; with r[1]=magnitude and r[2]=angle}
COMPLEXCONVERT(A1,A2,1,R2);
COMPLEXCONVERT(B1,B2,1,R3);
IF MODE=1 THEN
BEGIN
A:=R2[1]+R3[1];
B:=R2[2]+R3[2];
COMPLEXCONVERT(A,B,0,R2);
R1(R)[1]:=R2[1];
R1(R)[2]:=R2[2];
END
ELSE
BEGIN
A:=R2[1]-R3[1];
B:=R2[2]-R3[2];
COMPLEXCONVERT(A,B,0,R2);
R1(R)[1]:=R2[1];
R1(R)[2]:=R2[2];
END;
END;

PROCEDURE POWERCR_CP(A1,A2,B1,B2:REAL;MODE:INTEGER;VAR R);
TYPE
R1=ARRAY[1..2] OF REAL;
VAR
A,B,C,D,E:REAL;
R2:ARRAY[1..2] OF REAL;
R3:ARRAY[1..2] OF REAL;
BEGIN
{if mode is 1 then powercr_cp takes rect complex numbers a and b and raises a to power of b else
powercr_cp takes to polar comples numbers and raises a to b, results stored, as usual, in r}
IF MODE=1 THEN
BEGIN
COMPLEXCONVERT(A1,A2,0,R2);
A:=POWER1(R2[1],B1,0);
B:=EXP((-R2[2])*B2);
C:=LN(R2[1]);
D:=C*B2;
E:=D+R2[2]*B1;
COMPLEXCONVERT(A*B,E,1,R3);
R1(R)[1]:=R3[1];
R1(R)[2]:=R3[2];
END
ELSE
BEGIN
A:=POWER1(A1,B1,0);
B:=EXP((-A2)*B2);
C:=LN(A1);
D:=C*B2;
E:=D+A2*B1;
R1(R)[1]:=A*B;
R1(R)[2]:=E;
END;
END;

PROCEDURE RAYS_XYZ(X,Y,Z,X1,Y1,Z1,X2,Y2,Z2,XM1,YM1,ZM1:REAL;COUNT:INTEGER;VAR RIN,ROUT);
TYPE
RIN1=ARRAY[1..100,1..3] OF REAL;
ROUT1=ARRAY[1..100,1..3] OF REAL;
VAR
A:INTEGER;
H2:ARRAY[1..3] OF REAL;
BEGIN
{rays_xyz takes an array of xyz numbers,in rin, up to a 100, and rotates and displaces them
and places the results in rout,  x,y,z is new coordinates for origin, x1,y1,y3 new vector for
z axis, x2,y2,z2 new x axis vector, xm1,ym1,zm1 amplitudes for points, count= number of points to be
processed, rin =incoming array of points, rout=outgoing array of points}
FOR A:=1 TO COUNT DO
BEGIN
XYZROTTRANS(RIN1(RIN)[A,1],RIN1(RIN)[A,2],RIN1(RIN)[A,3],X1,Y1,Z1,X2,Y2,Z2,X,Y,Z,XM1,YM1,ZM1,1,H2);
ROUT1(ROUT)[A,1]:=H2[1];
ROUT1(ROUT)[A,2]:=H2[2];
ROUT1(ROUT)[A,3]:=H2[3];
END;
END;

END.






