program TestTimer;

uses WinTypes, WinProcs, OWindows, SysTimer, ODialogs;

type

  TTimerApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PTestWindow = ^TTestWindow;
  TTestWindow = object(tWindow)
    TheTimer: pSystemTimer;
    Counter : LongInt;

    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure   SetupWindow;                                    virtual;
    destructor  Done;                                           virtual;
    { This will be called by our timer. }
    procedure   wmSystemTimer(var Msg: tMessage);               virtual wm_First + wm_SystemTimer;
  end;


constructor TTestWindow.Init(AParent: PWindowsObject; ATitle: PChar);
var
  P: PWindowsObject;
begin
  inherited Init(AParent, ATitle);
  P := New(PStatic, Init(@Self, -1, 'Elapsed:', 20, 20, 100, 100, 20));
  P := New(PStatic, Init(@Self, 101, '', 120, 20, 100, 100, 20));
end;

procedure TTestWindow.SetupWindow;
begin
  inherited SetupWindow;
  Counter := 0;
  { If delay equals the resolution, the system will probably become saturated with }
  { messages and effectively lock up the application if the procedure tries to do  }
  { too much processing.  The screen updating performed below in wmSystemTimer     }
  { WILL cause this if you set the delay to 1 (or the resolution to 2).            }
  TheTimer := New(pSystemTimer, Init(hWindow, 2, 1, FALSE));
  if TheTimer = NIL then
    MessageBox(hWindow, 'Failed to create timer.', 'Error:', MB_OK);
end;

destructor TTestWindow.Done;
var
  Test: array[0..15] of char;
begin
  if assigned(TheTimer) then
    Dispose(TheTimer, Done);
  Str(Counter*2, Test);
  MessageBox(hWindow, Test, 'Elapsed Milliseconds', MB_OK);
  inherited Done;
end;

{ Receives the timer ID in wParam and the callback function address in lParam. }
procedure TTestWindow.wmSystemTimer(var Msg: tMessage);
var
  Test: array[0..15] of char;
begin
  inc(Counter);
  { We get called once every 2 milliseconds }
  Str(Counter*2, Test);
  SendDlgItemMessage(hWindow, 101, wm_SetText, 0, LongInt(@Test));
end;



procedure TTimerApp.InitMainWindow;
begin
  MainWindow := New(PTestWindow, Init(nil, 'High Resolution System Timer App'));
end;

var
  TimerApp: TTimerApp;

begin
  TimerApp.Init('TimerApp');
  TimerApp.Run;
  TimerApp.Done;
end.
