unit page_07;

interface

uses crt, ifpglobl, ifpcomon;

procedure page07;

implementation

procedure page07;

const
  mouseint = $33;
  mouselang: array [0..8] of string[10] = ('English', 'French', 'Dutch',
          'German', 'Swedish', 'Finnish', 'Spanish', 'Portuguese', 'Italian');

var
  xbyte : byte;
  xword1 : word;
  xword2 : word;
  jsfound: boolean;
  eqjs: boolean;
  oldx, oldy, oldattr: byte;
  xlong: longint;

  begin
  caption2('Keyboard');
  Writeln;
  caption3('BIOS support for enhanced keyboard');
  with regs do
    begin
    AH:=$02;
    Intr($16, regs);
    xbyte:=AL;
    AX:=$1200 + xbyte xor $FF;
    Intr($16, regs);
    if AL = xbyte then
      begin
      Write('yes');
      caption3('Enhanced keyboard present');
      yesorno(Mem[BIOSdseg : $0096] and $10 = $10)
      end
    else
      Writeln('no');
(*  PC Magazine 6:15 p.378  *)
    AH:=$02;
    Intr($16, regs);
    offoron('Insert     ', AL and $80 = $80);
    offoron('Caps Lock  ', AL and $40 = $40);
    offoron('Num Lock   ', AL and $20 = $20);
    offoron('Scroll Lock', AL and $10 = $10)
    end;
  caption3('Buffer start');
  xword1:=Memw[BIOSdseg : $0080];
  segofs(BIOSdseg, xword1);
  caption3(' end');
  xword2:=Memw[BIOSdseg : $0082];
  segofs(BIOSdseg, xword2);
  caption3(' size (keystrokes)');
  Writeln((xword2 - xword1) shr 1 - 1);
  caption2('Internal modem [IBM Convertible]/serial printer [PCjr]');
  yesorno(equip and $2000 = $2000);
  caption2('Game port');
  xword:=0;
  jsfound:=false;
  Port[$201]:=1;
  if Port[$201] and $F <> $F then
    jsfound:=false
  else
    repeat
      if (Port[$201] and $F) <> $F then
        jsfound:=true;
      Inc(xword);
    until (xword = $F00) or jsfound;
  if jsfound then
    Write('yes, and ')
  else
    Write('no, and ');
  if (equip and $1000) <> $1000 then
    Write('NOT')
  else
    Write('IS');
  Writeln(' set in BIOS equipment word');
  caption2('Mouse');
  with regs do
    begin
    oldx:=WhereX;
    oldy:=WhereY;
    oldattr:=TextAttr;
    TextColor(LightRed + Blink);
    Write('** Searching for Mouse **');
    TextAttr:=oldattr;
    GotoXY(oldx, oldy);
    AX:=$0021;
    Intr(mouseint, regs);
    ClrEol;
    if AX = $FFFF then
      begin
      Write('yes');
      caption3('Buttons');
      if BX = $FFFF then
        BX:=2;
      Writeln(BX);
      AX:=$0070;
      BX:=$ABCD;
      Intr(mouseint, regs);
      if (AX = $ABCD) and (MemW[BX:CX] = $ABCD) and
        (MemW[BX:CX + 8] = $ABCD) then
        begin
        caption3('Mouse Systems version');
        xword:=MemW[MemW[BX:CX + 4]:MemW[BX:CX + 2]];
        Writeln(Hi(xword), decimal, addzero(Lo(xword)));
        end;
      AX:=$266C;
      BX:=0;
      CX:=0;
      Intr(mouseint, regs);
      if BX = $5353 {SS} then
        begin
        caption3('Logitech version');
        Write(Chr(CH), decimal, Chr(CL), 'x');
        if Chr(CH) >= '4' then
          begin
          caption3('Ballistics');
          AX:=$1F6C;
          BX:=0;
          CX:=0;
          Intr(mouseint, regs);
          if BX = 0 then
            Write('off')
          else
            case CX of
              1: Write('low');
              2: Write('high')
            else
              Write('???');
            end;
          caption3('Hand');
          AX:=$216C;
          BX:=0;
          Intr(mouseint, regs);
          if BX = 0 then
            Writeln('right')
          else
            Writeln('left')
          end;
        end;
      caption3('Microsoft version standard');
      AX:=$0024;
      Intr(mouseint, regs);
      if AX < $FFFF then
        begin
        Writeln(BH, decimal, addzero(unbcd(BL)));
        caption3('Type');
        case CH of
          $01 : Write('bus');
          $02 : Write('serial');
          $03 : Write('InPort');
          $04 : Write('PS/2');
          $05 : Write('HP')
          else
            unknown('mouse', CH, 2)
        end;
        caption3('Interrupt');
        case CL of
          $00 : Writeln('PS/2');
          $02..$05, $07 : Writeln('IRQ', CL)
          else
            unknown('interrupt', CL, 2)
        end;
      caption3('EGA register support');
      AH:=$FA;
      BX:=0;
      Intr($10, regs);
        if BX <> 0 then
        begin
        Write('yes');
        caption3('version');
        Writeln(unbcd(Mem[ES:BX]), decimal, addzero(unbcd(Mem[ES:BX+1])))
        end
      else
        Writeln('no');
      caption3('Save state buffer size (bytes)');
      AX:=$0015;
      Intr(mouseint, regs);
      Writeln(BX);
      caption3('Mickeys/pixel (horizontal)');
      AX:=$001B;
      Intr(mouseint, regs);
      Write(BX : 5);
      caption3(' (vertical)');
      Writeln(CX : 5);
      caption3('Double speed threshold');
      Writeln(DX);
      caption3('Current display page');
      AX:=$001E;
      Intr(mouseint, regs);
      Writeln(BX);
      caption3('Language');
      AX:=$0023;
      Intr(mouseint, regs);
      if AX < $FFFF then
        if BX < 9 then
          Writeln(mouselang[BX])
        else
          unknown('language', BX, 4)
      else
        Writeln('N/A');
        end
      else
        dontknow
      end
    else
      Writeln('no')
    end
  end;
end.