(******************************************************************************
*                                    hdr3d                                    *
******************************************************************************)
unit hdr3d;

{this is the 3D program header of globals, types etc..}

interface

const
    MaxPoints  = 20;
    MaxLines   = 50;
    maxObjects = 9; {size of object table}
    maxMacros  = 5; {size of macro table}
    maxNest    = 10; {size of loop table of interpreter}
    UNTITLED   = 'UNTITLED';
    UNTITLEDC  = 'UNTITLED.3DS';
    UNTITLEDS  = 'UNTITLED.3D2';

const ScreenWidth = 1000;
      HalfWidth   = screenWidth / 2;

       radFactor = 180 / 3.1415926535897932385;

type
    Line3d  = record
       FromP, ToP  : integer;
    end;
    screenPoints = record
       sX,sY : integer;
    end;
    axisType = (x,y,z);

type
    point3d = record
       x, y, z     : real;
    end;

const
       zeroPoint : point3d = (x:0.0; y:0.0; z:0.0);
       xAxis : integer = 45;
       yAxis : integer = 45;

var
       cosine_x,cosine_y,sine_x,sine_y : Real;
       currentPath : string[32];
const
       currentAxis : axisType = x;


Procedure CalcAxisDeg;
procedure setDefaultSuffix(var Fname : string; suffix : string);

implementation

(******************************************************************************
*                                 CalcAxisDeg                                 *
******************************************************************************)
Procedure CalcAxisDeg;

 {calculate sines & cosines of axis, xAxis + yAxis = 90!}

Begin
     Cosine_X := cos(Xaxis/RadFactor);
     Cosine_Y := cos(Yaxis/RadFactor);
     Sine_X   := sin(Xaxis/RadFactor);
     Sine_Y   := sin(Yaxis/RadFactor);
End;

(*******************************************************************************
*                              setDefaultSuffix                                *
*   Set the suffix if Fname to .suffix, if it does not have a suffix           *
*******************************************************************************)

procedure setDefaultSuffix;
var
    i  : integer;
begin
    i := length(Fname);
    while (i > 0) and (Fname[i] <> '.') do
       dec(i);
    if (i = 0) then
       Fname := Fname + '.' + suffix;
end;

begin
       getdir(0, currentPath);
       calcAxisDeg;
end.
