{*
*   TvConst.pas
*
*   Declare Turbo Vision command constants.
*
*   Copyright 1992 by Richard W. Hansen
*
*}

UNIT TvConst;

{$I TVDEFS.INC}

INTERFACE


CONST
  efRequired      = $0001;  { Field entry is required       }
  efRJustify      = $0002;  { Trim and Right justify result }
  efLJustify      = $0004;  { Trim and Left justify result  }
  efTrim          = $0008;  { Trim all pad chars from result}
  efHide          = $0010;  { Password input                }


  cmMaximize      = 250;    { minimize a window }
  cmMinimize      = 251;    { maximize a window }
  cmStartJob      = 252;    
  cmPauseJob      = 253;
  cmContinueJob   = 254;
  cmCancelJob     = 255;
  cmJobComplete   = 9999;

  cmMarkStart     = 10000;  { Start of marked menu items            }
  cmMarkEnd       = 11000;  { End of marked menu items
                             Start and End are used by HandleEvent
                             to toggle menu markers.               }
  cmCursorMoved   = 11001;
  cmUpdateView    = 11002;
  cmEditView      = 11003;

  cmScrollUp      = 11010;
  cmScrollDown    = 11011;
  cmPrint         = 11012;

  cmDisplayStr    = 11020;
  cmDisplayClr    = 11021;

  cmPopMenu       = 11030;

  {$IFDEF TVSCROLL}
  gfGrowXYRel     = $80;
  cmDragView      = 11040;
  {$ENDIF}

  cmFieldError    = 11060;
  cmIdentify      = 11061;
  cmLoseFocus     = 11062;

  cmListItemFocused = 13000;

CONST
  ErrorMsg        : String[80] = '';


IMPLEMENTATION
END.
