@echo off
rem Parameters:
rem
rem %1 = Mex compiler executable name
rem %2 = Mecca compiler executable name
rem %3 = Language compiler executable name
rem %4 = Batch file extension (.CMD for OS/2 and .BAT for dos)
rem %5 = Path to main maximus directory
rem %6 = Mex include path
rem %7 = english.mad path
rem %8 = max.prm path

rem Check parameters
if %4. == .   goto erDirectcall
if %5. == -h. goto erSyntax
if %5. == .   goto noParam4
if %6. == .   goto noParam5
if %7. == .   goto noParam6
if %8. == .   goto noParam7

rem Search for required files
call chkfile %6\max.mh
call chkfile %5\%1
call chkfile %5\%2
call chkfile %5\%3
call chkfile verify.mex
call chkfile %8
if exist blderror.flg goto fileError

rem Set environment variables
echo set MEX_INCLUDE=%MEX_INCLUDE%>envtemp.%4
echo set MAXIMUS=%MAXIMUS%>>envtemp.%4
set MEX_INCLUDE=%6
set MAXIMUS=%8

rem Compile it.
echo.
echo Compiling the Padlock call back verifier...
echo.

%5\%3 %7
%5\%1 init
%5\%1 getphone
%5\%1 checknum
%5\%1 verify
%5\%1 unreg
%5\%1 checkreg
%5\%1 dumpunrg
%5\%1 reg
%5\%2 *.mec

echo.
echo Finished compilation. If there were any error messages, you must
echo correct those errors before proceeding.
echo.
goto done

rem -------------------------------------------------------------------------- 
rem                                  Errors
rem --------------------------------------------------------------------------

rem Batch file was called directly
:erDirectCall
echo.
echo Don't try to use this batch file directly. Type BUILD instead.
echo.
goto done

rem Syntax error
:erSyntax
echo.
echo This batch file compiles the Padlock call back verifier.
echo.
echo Syntax:
echo.
echo   BUILD [switches] [maximus] [mex include] [english.mad] [max.prm]
echo.
echo Parameters:        Meaning:
echo   [maximus]        Path to your Maximus executables.
echo   [mex include]    Path your Mex include directory (containing max.mh).
echo   [english.mad]    Full path and filename of ENGLISH.MAD
echo   [max.prm]        Full path and filename of MAX.PRM
echo.
echo Switches:          Meaning:
echo   -h               Show this help screen
echo.
goto done

:fileError
if exist blderror.flg del blderror.flg
echo.
echo A required file was missing. Compilation aborted.
echo.
goto done

rem -------------------------------------------------------------------------- 
rem                                  Subroutines
rem --------------------------------------------------------------------------

:noParam4
if exist ..\%1 BLDGUTS %1 %2 %3 %4 ..
goto erSyntax

:noParam5
if exist %5\m\max.mh BLDGUTS %1 %2 %3 %4 %5 %5\m
if %MEX_INCLUDE%. == . goto erSyntax
if exist %MEX_INCLUDE%\max.mh BLDGUTS %1 %2 %3 %4 %5 %MEX_INCLUDE%
goto erSyntax

:noParam6
if exist %5\lang\english.mad BLDGUTS %1 %2 %3 %4 %5 %6 %5\lang\english.mad
goto erSyntax

:noParam7
if exist %5\max.prm BLDGUTS %1 %2 %3 %4 %5 %6 %7 %5\max.prm
if %MAXIMUS%. == . goto erSyntax
if exist %MAXIMUS% BLDGUTS %1 %2 %3 %4 %5 %6 %7 %MAXIMUS%
goto erSyntax

rem ---------------------------------------------------------------------
rem Clean up
rem ---------------------------------------------------------------------

:done

rem Restore old environment variable state
if exist envtemp.%4 call envtemp.%4
if exist envtemp.%4 del envtemp.%4

